/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.browser.provider.parser.errorlog.listener;

import lombok.Generated;
import org.apache.skywalking.apm.network.language.agent.v3.ErrorCategory;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.browser.source.BrowserErrorCategory;
import org.apache.skywalking.oap.server.core.browser.source.BrowserErrorLog;
import org.apache.skywalking.oap.server.core.config.NamingControl;
import org.apache.skywalking.oap.server.core.source.ISource;
import org.apache.skywalking.oap.server.core.source.SourceReceiver;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.receiver.browser.provider.BrowserServiceModuleConfig;
import org.apache.skywalking.oap.server.receiver.browser.provider.parser.errorlog.BrowserErrorLogDecorator;
import org.apache.skywalking.oap.server.receiver.browser.provider.parser.errorlog.listener.ErrorLogAnalysisListener;
import org.apache.skywalking.oap.server.receiver.browser.provider.parser.errorlog.listener.ErrorLogListenerFactory;
import org.apache.skywalking.oap.server.receiver.browser.provider.parser.errorlog.listener.ErrorLogRecordSampler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorLogRecordListener
implements ErrorLogAnalysisListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ErrorLogRecordListener.class);
    private final NamingControl namingControl;
    private final SourceReceiver sourceReceiver;
    private final BrowserErrorLog errorLog = new BrowserErrorLog();
    private final ErrorLogRecordSampler sampler;
    private SampleStatus sampleStatus = SampleStatus.UNKNOWN;

    @Override
    public void build() {
        if (this.sampleStatus.equals((Object)SampleStatus.SAMPLED)) {
            this.sourceReceiver.receive((ISource)this.errorLog);
        }
    }

    @Override
    public void parse(BrowserErrorLogDecorator decorator) {
        if (StringUtil.isEmpty((String)decorator.getUniqueId())) {
            if (log.isDebugEnabled()) {
                log.debug("Because uniqueId is empty BrowserErrorLog is ignored.");
            }
            this.sampleStatus = SampleStatus.IGNORED;
            return;
        }
        if (!this.sampler.shouldSample(decorator.getUniqueId().hashCode())) {
            this.sampleStatus = SampleStatus.IGNORED;
            return;
        }
        this.sampleStatus = SampleStatus.SAMPLED;
        this.errorLog.setUniqueId(decorator.getUniqueId());
        this.errorLog.setTimeBucket(TimeBucket.getRecordTimeBucket((long)decorator.getTime()));
        this.errorLog.setTimestamp(decorator.getTime());
        String serviceName = this.namingControl.formatServiceName(decorator.getService());
        String serviceId = IDManager.ServiceID.buildId((String)serviceName, (boolean)true);
        this.errorLog.setServiceId(serviceId);
        this.errorLog.setServiceVersionId(IDManager.ServiceInstanceID.buildId((String)serviceId, (String)this.namingControl.formatInstanceName(decorator.getServiceVersion())));
        String pagePath = this.namingControl.formatEndpointName(serviceName, decorator.getPagePath());
        this.errorLog.setPagePathId(IDManager.EndpointID.buildId((String)serviceId, (String)pagePath));
        this.errorLog.setErrorCategory(BrowserErrorCategory.fromErrorCategory((ErrorCategory)decorator.getCategory()));
        this.errorLog.setDataBinary(decorator.toByteArray());
    }

    @Generated
    public ErrorLogRecordListener(NamingControl namingControl, SourceReceiver sourceReceiver, ErrorLogRecordSampler sampler) {
        this.namingControl = namingControl;
        this.sourceReceiver = sourceReceiver;
        this.sampler = sampler;
    }

    public static class Factory
    implements ErrorLogListenerFactory {
        private final SourceReceiver sourceReceiver;
        private final NamingControl namingControl;
        private final ErrorLogRecordSampler sampler;

        public Factory(ModuleManager moduleManager, BrowserServiceModuleConfig moduleConfig) {
            this.sourceReceiver = (SourceReceiver)moduleManager.find("core").provider().getService(SourceReceiver.class);
            this.namingControl = (NamingControl)moduleManager.find("core").provider().getService(NamingControl.class);
            this.sampler = new ErrorLogRecordSampler(moduleConfig.getSampleRate());
        }

        @Override
        public ErrorLogAnalysisListener create(ModuleManager moduleManager, BrowserServiceModuleConfig moduleConfig) {
            return new ErrorLogRecordListener(this.namingControl, this.sourceReceiver, this.sampler);
        }
    }

    private static enum SampleStatus {
        UNKNOWN,
        SAMPLED,
        IGNORED;

    }
}

