/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.browser.provider.handler.rest;

import com.linecorp.armeria.server.annotation.Post;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.apm.network.common.v3.Commands;
import org.apache.skywalking.apm.network.language.agent.v3.BrowserErrorLog;
import org.apache.skywalking.apm.network.language.agent.v3.BrowserPerfData;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.receiver.browser.provider.BrowserServiceModuleConfig;
import org.apache.skywalking.oap.server.receiver.browser.provider.parser.errorlog.ErrorLogAnalyzer;
import org.apache.skywalking.oap.server.receiver.browser.provider.parser.errorlog.ErrorLogParserListenerManager;
import org.apache.skywalking.oap.server.receiver.browser.provider.parser.performance.PerfDataAnalyzer;
import org.apache.skywalking.oap.server.receiver.browser.provider.parser.performance.PerfDataParserListenerManager;
import org.apache.skywalking.oap.server.telemetry.api.CounterMetrics;
import org.apache.skywalking.oap.server.telemetry.api.HistogramMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserPerfServiceHTTPHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BrowserPerfServiceHTTPHandler.class);
    private final ModuleManager moduleManager;
    private final BrowserServiceModuleConfig config;
    private final ErrorLogParserListenerManager errorLogListenerManager;
    private final PerfDataParserListenerManager perfDataListenerManager;
    private final HistogramMetrics perfHistogram;
    private final CounterMetrics perfErrorCounter;
    private final HistogramMetrics errorLogHistogram;
    private final CounterMetrics logErrorCounter;

    public BrowserPerfServiceHTTPHandler(ModuleManager moduleManager, BrowserServiceModuleConfig config, ErrorLogParserListenerManager errorLogListenerManager, PerfDataParserListenerManager perfDataListenerManager) {
        this.moduleManager = moduleManager;
        this.config = config;
        this.errorLogListenerManager = errorLogListenerManager;
        this.perfDataListenerManager = perfDataListenerManager;
        MetricsCreator metricsCreator = (MetricsCreator)moduleManager.find("telemetry").provider().getService(MetricsCreator.class);
        this.perfHistogram = metricsCreator.createHistogramMetric("browser_perf_data_in_latency", "The process latency of browser performance data", new MetricsTag.Keys(new String[]{"protocol"}), new MetricsTag.Values(new String[]{"http"}), new double[0]);
        this.perfErrorCounter = metricsCreator.createCounter("browser_perf_data_analysis_error_count", "The error number of browser performance data analysis", new MetricsTag.Keys(new String[]{"protocol"}), new MetricsTag.Values(new String[]{"http"}));
        this.errorLogHistogram = metricsCreator.createHistogramMetric("browser_error_log_in_latency", "The process latency of browser error log", new MetricsTag.Keys(new String[]{"protocol"}), new MetricsTag.Values(new String[]{"grpc"}), new double[0]);
        this.logErrorCounter = metricsCreator.createCounter("browser_error_log_analysis_error_count", "The error number of browser error log analysis", new MetricsTag.Keys(new String[]{"protocol"}), new MetricsTag.Values(new String[]{"http"}));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Post(value="/browser/errorLog")
    public Commands collectSingleErrorLog(BrowserErrorLog browserErrorLog) {
        if (log.isDebugEnabled()) {
            log.debug("receive browser error log");
        }
        try (HistogramMetrics.Timer ignored = this.errorLogHistogram.createTimer();){
            ErrorLogAnalyzer analyzer = new ErrorLogAnalyzer(this.moduleManager, this.errorLogListenerManager, this.config);
            analyzer.doAnalysis(browserErrorLog);
            Commands commands = Commands.newBuilder().build();
            return commands;
        }
        catch (Throwable e) {
            this.logErrorCounter.inc();
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Post(value="/browser/errorLogs")
    public Commands collectErrorLogList(List<BrowserErrorLog> logs) {
        try (HistogramMetrics.Timer ignored = this.errorLogHistogram.createTimer();){
            logs.forEach(log -> {
                ErrorLogAnalyzer analyzer = new ErrorLogAnalyzer(this.moduleManager, this.errorLogListenerManager, this.config);
                analyzer.doAnalysis((BrowserErrorLog)log);
            });
            Commands commands = Commands.newBuilder().build();
            return commands;
        }
        catch (Throwable e) {
            this.logErrorCounter.inc();
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Post(value="/browser/perfData")
    public Commands collectPerfData(BrowserPerfData browserPerfData) {
        try (HistogramMetrics.Timer ignored = this.perfHistogram.createTimer();){
            PerfDataAnalyzer analyzer = new PerfDataAnalyzer(this.moduleManager, this.perfDataListenerManager, this.config);
            analyzer.doAnalysis(browserPerfData);
            Commands commands = Commands.newBuilder().build();
            return commands;
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            this.perfErrorCounter.inc();
            throw e;
        }
    }
}

