/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.envoy.metrics.adapters;

import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import io.prometheus.client.Metrics;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.receiver.envoy.EnvoyMetricReceiverConfig;
import org.apache.skywalking.oap.server.receiver.envoy.als.ServiceMetaInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterManagerMetricsAdapter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClusterManagerMetricsAdapter.class);
    private static final String DEFAULT_VALUE = "-";
    private final EnvoyMetricReceiverConfig config;

    public String adaptMetricsName(Metrics.MetricFamily metricFamily) {
        return "envoy_cluster_metrics";
    }

    public Map<String, String> adaptLabels(Metrics.MetricFamily metricFamily, Map<String, String> labels) {
        String metricsName = metricFamily.getName();
        labels.putIfAbsent("metrics_name", metricsName);
        String clusterName = null;
        try {
            clusterName = this.buildUpstreamServiceMetaInfo(metricFamily).getServiceName();
        }
        catch (Exception e) {
            log.error("Failed to build upstream serviceMetaInfo from metrics name. ", (Throwable)e);
        }
        if (StringUtil.isNotEmpty((String)clusterName)) {
            labels.putIfAbsent("cluster_name", clusterName);
        }
        return labels;
    }

    protected ServiceMetaInfo buildUpstreamServiceMetaInfo(Metrics.MetricFamily metricFamily) throws Exception {
        String[] splitArrClusterName;
        String[] splitArrBound;
        String metricsName = metricFamily.getName();
        String serviceName = DEFAULT_VALUE;
        String ns = DEFAULT_VALUE;
        String version = DEFAULT_VALUE;
        String[] splitArrGeneral = StringUtils.split((String)metricsName, (String)".");
        if (metricsName.startsWith("cluster.outbound")) {
            splitArrBound = metricsName.split("\\|");
            if (splitArrBound.length > 3) {
                splitArrClusterName = StringUtils.split((String)splitArrBound[3], (String)".");
                version = splitArrBound[2];
                if (splitArrClusterName.length > 1) {
                    if (StringUtil.isBlank((String)version)) {
                        version = "*";
                    }
                    serviceName = splitArrClusterName[0];
                    ns = splitArrClusterName[1];
                }
            }
        } else if (metricsName.startsWith("cluster.inbound")) {
            splitArrBound = metricsName.split("\\|");
            if (splitArrBound.length > 1 && (splitArrClusterName = StringUtils.split((String)splitArrBound[0], (String)".")).length > 1) {
                serviceName = splitArrClusterName[1] + ":" + splitArrBound[1];
            }
        } else if (splitArrGeneral.length == 3) {
            serviceName = splitArrGeneral[1];
        }
        Value nsValue = Value.newBuilder().setStringValue(ns).build();
        Value nameValue = Value.newBuilder().setStringValue(serviceName).build();
        Value versionValue = Value.newBuilder().setStringValue(version).build();
        Struct labelStruct = Struct.newBuilder().putFields("service.istio.io/canonical-name", nameValue).putFields("app.kubernetes.io/name", nameValue).putFields("app", nameValue).putFields("service.istio.io/canonical-revision", versionValue).putFields("version", versionValue).build();
        Value label = Value.newBuilder().setStructValue(labelStruct).build();
        Struct struct = Struct.newBuilder().putFields("NAMESPACE", nsValue).putFields("LABELS", label).build();
        return this.config.serviceMetaInfoFactory().fromStruct(struct);
    }

    @Generated
    public ClusterManagerMetricsAdapter(EnvoyMetricReceiverConfig config) {
        this.config = config;
    }
}

