/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.envoy.als.tcp.mx;

import com.google.protobuf.Any;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import io.envoyproxy.envoy.data.accesslog.v3.AccessLogCommon;
import io.envoyproxy.envoy.data.accesslog.v3.TCPAccessLogEntry;
import io.envoyproxy.envoy.service.accesslog.v3.StreamAccessLogsMessage;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.skywalking.apm.network.servicemesh.v3.ServiceMeshMetric;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.receiver.envoy.EnvoyMetricReceiverConfig;
import org.apache.skywalking.oap.server.receiver.envoy.als.AccessLogAnalyzer;
import org.apache.skywalking.oap.server.receiver.envoy.als.Role;
import org.apache.skywalking.oap.server.receiver.envoy.als.ServiceMetaInfo;
import org.apache.skywalking.oap.server.receiver.envoy.als.mx.FieldsHelper;
import org.apache.skywalking.oap.server.receiver.envoy.als.mx.ServiceMetaInfoAdapter;
import org.apache.skywalking.oap.server.receiver.envoy.als.tcp.AbstractTCPAccessLogAnalyzer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaExchangeTCPAccessLogAnalyzer
extends AbstractTCPAccessLogAnalyzer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetaExchangeTCPAccessLogAnalyzer.class);
    protected String fieldMappingFile = "metadata-service-mapping.yaml";
    protected EnvoyMetricReceiverConfig config;

    @Override
    public String name() {
        return "mx-mesh";
    }

    @Override
    public void init(ModuleManager manager, EnvoyMetricReceiverConfig config) throws ModuleStartException {
        this.config = config;
        try {
            FieldsHelper.SINGLETON.init(this.fieldMappingFile, config.serviceMetaInfoFactory().clazz());
        }
        catch (Exception e) {
            throw new ModuleStartException("Failed to load metadata-service-mapping.yaml", (Throwable)e);
        }
    }

    @Override
    public AccessLogAnalyzer.Result analysis(AccessLogAnalyzer.Result previousResult, StreamAccessLogsMessage.Identifier identifier, TCPAccessLogEntry entry, Role role) {
        ServiceMetaInfo currSvc;
        if (CollectionUtils.isNotEmpty(previousResult.getMetrics())) {
            return previousResult;
        }
        if (!entry.hasCommonProperties()) {
            return previousResult;
        }
        try {
            currSvc = this.adaptToServiceMetaInfo(identifier);
        }
        catch (Exception e) {
            log.error("Failed to inflate the ServiceMetaInfo from identifier.node.metadata. ", (Throwable)e);
            return previousResult;
        }
        AccessLogCommon properties = entry.getCommonProperties();
        Map stateMap = properties.getFilterStateObjectsMap();
        if (stateMap.isEmpty()) {
            return AccessLogAnalyzer.Result.builder().service(currSvc).build();
        }
        ArrayList<ServiceMeshMetric.Builder> result = new ArrayList<ServiceMeshMetric.Builder>();
        AtomicBoolean downstreamExists = new AtomicBoolean();
        stateMap.forEach((key, value) -> {
            ServiceMetaInfo svc;
            if (!key.equals("wasm.upstream_peer") && !key.equals("wasm.downstream_peer")) {
                return;
            }
            try {
                svc = this.adaptToServiceMetaInfo((Any)value);
            }
            catch (Exception e) {
                log.error("Fail to parse metadata {} to FlatNode", (Object)Base64.getEncoder().encode(value.toByteArray()));
                return;
            }
            switch (key) {
                case "wasm.upstream_peer": {
                    ServiceMeshMetric.Builder metrics = this.newAdapter(entry, currSvc, svc).adaptToUpstreamMetrics().setTlsMode("NONE");
                    if (log.isDebugEnabled()) {
                        log.debug("Transformed a {} outbound mesh metrics {}", (Object)role, (Object)TextFormat.shortDebugString((MessageOrBuilder)metrics));
                    }
                    result.add(metrics);
                    break;
                }
                case "wasm.downstream_peer": {
                    ServiceMeshMetric.Builder metrics = this.newAdapter(entry, svc, currSvc).adaptToDownstreamMetrics();
                    if (log.isDebugEnabled()) {
                        log.debug("Transformed a {} inbound mesh metrics {}", (Object)role, (Object)TextFormat.shortDebugString((MessageOrBuilder)metrics));
                    }
                    result.add(metrics);
                    downstreamExists.set(true);
                }
            }
        });
        if (role.equals((Object)Role.PROXY) && !downstreamExists.get()) {
            ServiceMeshMetric.Builder metric = this.newAdapter(entry, this.config.serviceMetaInfoFactory().unknown(), currSvc).adaptToDownstreamMetrics();
            if (log.isDebugEnabled()) {
                log.debug("Transformed a {} inbound mesh metric {}", (Object)role, (Object)TextFormat.shortDebugString((MessageOrBuilder)metric));
            }
            result.add(metric);
        }
        return AccessLogAnalyzer.Result.builder().metrics(result).service(currSvc).build();
    }

    protected ServiceMetaInfo adaptToServiceMetaInfo(Any value) throws Exception {
        return new ServiceMetaInfoAdapter(value);
    }

    protected ServiceMetaInfo adaptToServiceMetaInfo(StreamAccessLogsMessage.Identifier identifier) throws Exception {
        return this.config.serviceMetaInfoFactory().fromStruct(identifier.getNode().getMetadata());
    }
}

