/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.envoy.als.tcp.k8s;

import io.envoyproxy.envoy.config.core.v3.Address;
import io.envoyproxy.envoy.config.core.v3.SocketAddress;
import io.envoyproxy.envoy.data.accesslog.v3.AccessLogCommon;
import io.envoyproxy.envoy.data.accesslog.v3.TCPAccessLogEntry;
import io.envoyproxy.envoy.service.accesslog.v3.StreamAccessLogsMessage;
import java.util.ArrayList;
import lombok.Generated;
import org.apache.skywalking.apm.network.servicemesh.v3.ServiceMeshMetric;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.receiver.envoy.EnvoyMetricReceiverConfig;
import org.apache.skywalking.oap.server.receiver.envoy.als.AccessLogAnalyzer;
import org.apache.skywalking.oap.server.receiver.envoy.als.Role;
import org.apache.skywalking.oap.server.receiver.envoy.als.ServiceMetaInfo;
import org.apache.skywalking.oap.server.receiver.envoy.als.k8s.K8SServiceRegistry;
import org.apache.skywalking.oap.server.receiver.envoy.als.tcp.AbstractTCPAccessLogAnalyzer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class K8sALSServiceMeshTCPAnalysis
extends AbstractTCPAccessLogAnalyzer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(K8sALSServiceMeshTCPAnalysis.class);
    protected K8SServiceRegistry serviceRegistry;
    private EnvoyMetricReceiverConfig config;

    @Override
    public String name() {
        return "k8s-mesh";
    }

    @Override
    public void init(ModuleManager manager, EnvoyMetricReceiverConfig config) {
        this.config = config;
        this.serviceRegistry = new K8SServiceRegistry(config);
        this.serviceRegistry.start();
    }

    @Override
    public AccessLogAnalyzer.Result analysis(AccessLogAnalyzer.Result previousResult, StreamAccessLogsMessage.Identifier identifier, TCPAccessLogEntry entry, Role role) {
        if (CollectionUtils.isNotEmpty(previousResult.getMetrics())) {
            return previousResult;
        }
        if (this.serviceRegistry.isEmpty()) {
            return previousResult;
        }
        switch (role) {
            case PROXY: {
                return this.analyzeProxy(previousResult, entry);
            }
            case SIDECAR: {
                return this.analyzeSideCar(previousResult, entry);
            }
        }
        return previousResult;
    }

    protected AccessLogAnalyzer.Result analyzeSideCar(AccessLogAnalyzer.Result previousResult, TCPAccessLogEntry entry) {
        AccessLogCommon properties = entry.getCommonProperties();
        if (properties == null) {
            return previousResult;
        }
        String cluster = properties.getUpstreamCluster();
        if (cluster == null) {
            return previousResult;
        }
        ArrayList<ServiceMeshMetric.Builder> sources = new ArrayList<ServiceMeshMetric.Builder>();
        Address downstreamRemoteAddress = properties.hasDownstreamDirectRemoteAddress() ? properties.getDownstreamDirectRemoteAddress() : properties.getDownstreamRemoteAddress();
        ServiceMetaInfo downstreamService = this.find(downstreamRemoteAddress.getSocketAddress().getAddress());
        Address downstreamLocalAddress = properties.getDownstreamLocalAddress();
        ServiceMetaInfo localService = this.find(downstreamLocalAddress.getSocketAddress().getAddress());
        if (cluster.startsWith("inbound|")) {
            ServiceMeshMetric.Builder metrics;
            if (downstreamService.equals(this.config.serviceMetaInfoFactory().unknown())) {
                metrics = this.newAdapter(entry, null, localService).adaptToDownstreamMetrics();
                log.debug("Transformed ingress->sidecar inbound mesh metrics {}", (Object)metrics);
            } else {
                metrics = this.newAdapter(entry, downstreamService, localService).adaptToDownstreamMetrics();
                log.debug("Transformed sidecar->sidecar(server side) inbound mesh metrics {}", (Object)metrics);
            }
            sources.add(metrics);
        } else if (cluster.startsWith("outbound|")) {
            Address upstreamRemoteAddress = properties.getUpstreamRemoteAddress();
            ServiceMetaInfo destService = this.find(upstreamRemoteAddress.getSocketAddress().getAddress());
            ServiceMeshMetric.Builder metric = this.newAdapter(entry, downstreamService, destService).adaptToUpstreamMetrics();
            log.debug("Transformed sidecar->sidecar(server side) inbound mesh metric {}", (Object)metric);
            sources.add(metric);
        }
        return AccessLogAnalyzer.Result.builder().metrics(sources).service(localService).build();
    }

    protected AccessLogAnalyzer.Result analyzeProxy(AccessLogAnalyzer.Result previousResult, TCPAccessLogEntry entry) {
        AccessLogCommon properties = entry.getCommonProperties();
        if (properties == null) {
            return previousResult;
        }
        Address downstreamLocalAddress = properties.getDownstreamLocalAddress();
        Address downstreamRemoteAddress = properties.hasDownstreamDirectRemoteAddress() ? properties.getDownstreamDirectRemoteAddress() : properties.getDownstreamRemoteAddress();
        Address upstreamRemoteAddress = properties.getUpstreamRemoteAddress();
        if (downstreamLocalAddress == null || downstreamRemoteAddress == null || upstreamRemoteAddress == null) {
            return previousResult;
        }
        ArrayList<ServiceMeshMetric.Builder> result = new ArrayList<ServiceMeshMetric.Builder>(2);
        SocketAddress downstreamRemoteAddressSocketAddress = downstreamRemoteAddress.getSocketAddress();
        ServiceMetaInfo outside = this.find(downstreamRemoteAddressSocketAddress.getAddress());
        SocketAddress downstreamLocalAddressSocketAddress = downstreamLocalAddress.getSocketAddress();
        ServiceMetaInfo ingress = this.find(downstreamLocalAddressSocketAddress.getAddress());
        ServiceMeshMetric.Builder metric = this.newAdapter(entry, outside, ingress).adaptToDownstreamMetrics();
        log.debug("Transformed ingress inbound mesh metric {}", (Object)metric);
        result.add(metric);
        SocketAddress upstreamRemoteAddressSocketAddress = upstreamRemoteAddress.getSocketAddress();
        ServiceMetaInfo targetService = this.find(upstreamRemoteAddressSocketAddress.getAddress());
        ServiceMeshMetric.Builder outboundMetric = this.newAdapter(entry, ingress, targetService).adaptToUpstreamMetrics().setTlsMode("NONE");
        log.debug("Transformed ingress outbound mesh metric {}", (Object)outboundMetric);
        result.add(outboundMetric);
        return AccessLogAnalyzer.Result.builder().metrics(result).service(ingress).build();
    }

    protected ServiceMetaInfo find(String ip) {
        return this.serviceRegistry.findService(ip);
    }
}

