/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.envoy.als.k8s;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import io.kubernetes.client.openapi.models.V1Endpoints;
import io.kubernetes.client.openapi.models.V1Node;
import io.kubernetes.client.openapi.models.V1NodeAddress;
import io.kubernetes.client.openapi.models.V1NodeStatus;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.openapi.models.V1Service;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.library.kubernetes.KubernetesEndpointWatcher;
import org.apache.skywalking.library.kubernetes.KubernetesEndpointsListener;
import org.apache.skywalking.library.kubernetes.KubernetesNodeListener;
import org.apache.skywalking.library.kubernetes.KubernetesNodeWatcher;
import org.apache.skywalking.library.kubernetes.KubernetesPodListener;
import org.apache.skywalking.library.kubernetes.KubernetesPodWatcher;
import org.apache.skywalking.library.kubernetes.KubernetesServiceListener;
import org.apache.skywalking.library.kubernetes.KubernetesServiceWatcher;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.receiver.envoy.EnvoyMetricReceiverConfig;
import org.apache.skywalking.oap.server.receiver.envoy.als.ServiceMetaInfo;
import org.apache.skywalking.oap.server.receiver.envoy.als.k8s.ServiceNameFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class K8SServiceRegistry
implements KubernetesServiceListener,
KubernetesPodListener,
KubernetesEndpointsListener,
KubernetesNodeListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(K8SServiceRegistry.class);
    protected final Map<String, ServiceMetaInfo> ipServiceMetaInfoMap;
    protected final Map<String, V1Service> idServiceMap;
    protected final Map<String, V1Pod> ipPodMap;
    protected final Map<String, String> ipServiceMap;
    protected final ServiceNameFormatter serviceNameFormatter;
    private final EnvoyMetricReceiverConfig config;
    private final Set<String> nodeIPs = Collections.newSetFromMap(new ConcurrentHashMap());

    public K8SServiceRegistry(EnvoyMetricReceiverConfig config) {
        this.config = config;
        this.serviceNameFormatter = new ServiceNameFormatter(config.getK8sServiceNameRule());
        this.ipServiceMetaInfoMap = new ConcurrentHashMap<String, ServiceMetaInfo>();
        this.idServiceMap = new ConcurrentHashMap<String, V1Service>();
        this.ipPodMap = new ConcurrentHashMap<String, V1Pod>();
        this.ipServiceMap = new ConcurrentHashMap<String, String>();
    }

    public void start() throws IOException {
        KubernetesPodWatcher.INSTANCE.addListener((KubernetesPodListener)this).start();
        KubernetesServiceWatcher.INSTANCE.addListener((KubernetesServiceListener)this).start();
        KubernetesEndpointWatcher.INSTANCE.addListener((KubernetesEndpointsListener)this).start();
        KubernetesNodeWatcher.INSTANCE.addListener((KubernetesNodeListener)this).start();
    }

    public void onServiceAdded(V1Service service) {
        Optional.ofNullable(service.getMetadata()).ifPresent(metadata -> this.idServiceMap.put(metadata.getNamespace() + ":" + metadata.getName(), service));
        this.recompose();
    }

    public void onServiceDeleted(V1Service service) {
        Optional.ofNullable(service.getMetadata()).ifPresent(metadata -> this.idServiceMap.remove(metadata.getNamespace() + ":" + metadata.getName()));
    }

    public void onServiceUpdated(V1Service oldService, V1Service newService) {
        this.onServiceAdded(newService);
    }

    public void onPodAdded(V1Pod pod) {
        Optional.ofNullable(pod.getStatus()).flatMap(status -> Optional.ofNullable(status.getPodIP())).ifPresent(podIP -> this.ipPodMap.put((String)podIP, pod));
        this.recompose();
    }

    public void onPodDeleted(V1Pod pod) {
        Optional.ofNullable(pod.getStatus()).flatMap(status -> Optional.ofNullable(status.getPodIP())).ifPresent(this.ipPodMap::remove);
    }

    public void onPodUpdated(V1Pod oldPod, V1Pod newPod) {
        this.onPodAdded(newPod);
    }

    public void onEndpointsAdded(V1Endpoints endpoints) {
        V1ObjectMeta endpointsMetadata = endpoints.getMetadata();
        if (Objects.isNull(endpointsMetadata)) {
            log.error("Endpoints metadata is null: {}", (Object)endpoints);
            return;
        }
        String namespace = endpointsMetadata.getNamespace();
        String name = endpointsMetadata.getName();
        Optional.ofNullable(endpoints.getSubsets()).ifPresent(subsets -> subsets.forEach(subset -> Optional.ofNullable(subset.getAddresses()).ifPresent(addresses -> addresses.forEach(address -> Optional.ofNullable(address.getIp()).ifPresent(ip -> this.ipServiceMap.put((String)ip, namespace + ":" + name))))));
        this.recompose();
    }

    public void onEndpointsDeleted(V1Endpoints endpoints) {
        Optional.ofNullable(endpoints.getSubsets()).ifPresent(subsets -> subsets.forEach(subset -> Optional.ofNullable(subset.getAddresses()).ifPresent(addresses -> addresses.forEach(address -> Optional.ofNullable(address.getIp()).ifPresent(this.ipServiceMap::remove)))));
    }

    public void onEndpointsUpdated(V1Endpoints oldEndpoints, V1Endpoints newEndpoints) {
        this.onEndpointsAdded(newEndpoints);
    }

    public void onNodeAdded(V1Node node) {
        this.forEachAddress(node, this.nodeIPs::add);
    }

    public void onNodeUpdated(V1Node oldNode, V1Node newNode) {
        this.onNodeAdded(newNode);
    }

    public void onNodeDeleted(V1Node node) {
        this.forEachAddress(node, this.nodeIPs::remove);
    }

    protected void forEachAddress(V1Node node, Consumer<String> consume) {
        Optional.ofNullable(node).map(V1Node::getStatus).map(V1NodeStatus::getAddresses).ifPresent(addresses -> addresses.stream().map(V1NodeAddress::getAddress).filter(StringUtil::isNotBlank).forEach(consume));
    }

    protected List<ServiceMetaInfo.KeyValue> transformLabelsToTags(V1ObjectMeta podMeta) {
        Map labels = podMeta.getLabels();
        ArrayList<ServiceMetaInfo.KeyValue> tags = new ArrayList<ServiceMetaInfo.KeyValue>();
        tags.add(new ServiceMetaInfo.KeyValue("pod", podMeta.getName()));
        tags.add(new ServiceMetaInfo.KeyValue("namespace", podMeta.getNamespace()));
        if (Objects.isNull(labels)) {
            return tags;
        }
        return labels.entrySet().stream().map(each -> new ServiceMetaInfo.KeyValue((String)each.getKey(), (String)each.getValue())).collect(Collectors.toCollection(() -> tags));
    }

    public ServiceMetaInfo findService(String ip) {
        if (this.isNode(ip)) {
            return this.config.serviceMetaInfoFactory().unknown();
        }
        ServiceMetaInfo service = this.ipServiceMetaInfoMap.get(ip);
        if (Objects.isNull(service)) {
            log.debug("Unknown ip {}, ip -> service is null", (Object)ip);
            return this.config.serviceMetaInfoFactory().unknown();
        }
        return service;
    }

    protected void recompose() {
        this.ipPodMap.forEach((ip, pod) -> {
            V1Service service;
            String namespaceService = this.ipServiceMap.get(ip);
            if (Strings.isNullOrEmpty((String)namespaceService) || Objects.isNull(service = this.idServiceMap.get(namespaceService))) {
                return;
            }
            if (Objects.isNull(pod.getMetadata())) {
                log.warn("Pod metadata is null, {}", pod);
                return;
            }
            this.ipServiceMetaInfoMap.computeIfAbsent((String)ip, unused -> this.composeServiceMetaInfo(service, (V1Pod)pod));
        });
    }

    protected ServiceMetaInfo composeServiceMetaInfo(V1Service service, V1Pod pod) {
        ImmutableMap context = ImmutableMap.of((Object)"service", (Object)service, (Object)"pod", (Object)pod);
        ServiceMetaInfo serviceMetaInfo = new ServiceMetaInfo();
        V1ObjectMeta podMetadata = pod.getMetadata();
        try {
            serviceMetaInfo.setServiceName(this.serviceNameFormatter.format((Map<String, Object>)context));
        }
        catch (Exception e) {
            log.error("Failed to evaluate service name.", (Throwable)e);
            V1ObjectMeta serviceMetadata = service.getMetadata();
            if (Objects.isNull(serviceMetadata)) {
                log.warn("Service metadata is null, {}", (Object)service);
                return this.config.serviceMetaInfoFactory().unknown();
            }
            serviceMetaInfo.setServiceName(serviceMetadata.getName());
        }
        serviceMetaInfo.setServiceInstanceName(String.format("%s.%s", podMetadata.getName(), podMetadata.getNamespace()));
        serviceMetaInfo.setTags(this.transformLabelsToTags(podMetadata));
        return serviceMetaInfo;
    }

    public boolean isNode(String ip) {
        return this.nodeIPs.contains(ip);
    }

    public boolean isEmpty() {
        return this.ipServiceMetaInfoMap.isEmpty();
    }
}

