/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.envoy;

import io.grpc.BindableService;
import org.apache.skywalking.oap.server.core.oal.rt.OALDefine;
import org.apache.skywalking.oap.server.core.oal.rt.OALEngineLoaderService;
import org.apache.skywalking.oap.server.core.server.GRPCHandlerRegister;
import org.apache.skywalking.oap.server.library.module.ModuleConfig;
import org.apache.skywalking.oap.server.library.module.ModuleDefine;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;
import org.apache.skywalking.oap.server.receiver.envoy.AccessLogServiceGRPCHandler;
import org.apache.skywalking.oap.server.receiver.envoy.AccessLogServiceGRPCHandlerV3;
import org.apache.skywalking.oap.server.receiver.envoy.EnvoyMetricReceiverConfig;
import org.apache.skywalking.oap.server.receiver.envoy.EnvoyMetricReceiverModule;
import org.apache.skywalking.oap.server.receiver.envoy.MetricServiceGRPCHandler;
import org.apache.skywalking.oap.server.receiver.envoy.MetricServiceGRPCHandlerV3;
import org.apache.skywalking.oap.server.receiver.envoy.SatelliteAccessLogServiceGRPCHandlerV3;
import org.apache.skywalking.oap.server.receiver.envoy.TCPOALDefine;
import org.apache.skywalking.oap.server.receiver.envoy.als.mx.FieldsHelper;

public class EnvoyMetricReceiverProvider
extends ModuleProvider {
    private final EnvoyMetricReceiverConfig config = new EnvoyMetricReceiverConfig();
    protected String fieldMappingFile = "metadata-service-mapping.yaml";

    public String name() {
        return "default";
    }

    public Class<? extends ModuleDefine> module() {
        return EnvoyMetricReceiverModule.class;
    }

    public ModuleConfig createConfigBeanIfAbsent() {
        return this.config;
    }

    public void prepare() throws ServiceNotProvidedException, ModuleStartException {
        try {
            FieldsHelper.SINGLETON.init(this.fieldMappingFile, this.config.serviceMetaInfoFactory().clazz());
        }
        catch (Exception e) {
            throw new ModuleStartException("Failed to load metadata-service-mapping.yaml", (Throwable)e);
        }
    }

    public void start() throws ServiceNotProvidedException, ModuleStartException {
        Object handler;
        if (!this.config.getAlsTCPAnalysis().isEmpty()) {
            ((OALEngineLoaderService)this.getManager().find("core").provider().getService(OALEngineLoaderService.class)).load((OALDefine)TCPOALDefine.INSTANCE);
        }
        GRPCHandlerRegister service = (GRPCHandlerRegister)this.getManager().find("receiver-sharing-server").provider().getService(GRPCHandlerRegister.class);
        if (this.config.isAcceptMetricsService()) {
            handler = new MetricServiceGRPCHandler(this.getManager(), this.config);
            service.addHandler((BindableService)handler);
            service.addHandler((BindableService)new MetricServiceGRPCHandlerV3((MetricServiceGRPCHandler)((Object)handler)));
        }
        handler = new AccessLogServiceGRPCHandler(this.getManager(), this.config);
        service.addHandler((BindableService)handler);
        service.addHandler((BindableService)new AccessLogServiceGRPCHandlerV3((AccessLogServiceGRPCHandler)((Object)handler)));
        service.addHandler((BindableService)new SatelliteAccessLogServiceGRPCHandlerV3((AccessLogServiceGRPCHandler)((Object)handler)));
    }

    public void notifyAfterCompleted() throws ServiceNotProvidedException, ModuleStartException {
    }

    public String[] requiredModules() {
        return new String[]{"telemetry", "core", "receiver-sharing-server", "service-mesh"};
    }
}

