/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb.stream;

import java.io.IOException;
import lombok.Generated;
import org.apache.skywalking.banyandb.v1.client.StreamWrite;
import org.apache.skywalking.oap.server.core.analysis.DownSampling;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.analysis.record.Record;
import org.apache.skywalking.oap.server.core.storage.IRecordDAO;
import org.apache.skywalking.oap.server.core.storage.StorageData;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;
import org.apache.skywalking.oap.server.library.client.request.InsertRequest;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBConverter;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.MetadataRegistry;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.BanyanDBStreamInsertRequest;

public class BanyanDBRecordDAO
implements IRecordDAO {
    private final StorageBuilder<Record> storageBuilder;

    public InsertRequest prepareBatchInsert(Model model, Record record) throws IOException {
        MetadataRegistry.Schema schema = MetadataRegistry.INSTANCE.findMetadata(model.getName());
        if (schema == null) {
            throw new IOException(model.getName() + " is not registered");
        }
        StreamWrite streamWrite = new StreamWrite(schema.getMetadata().getGroup(), model.getName(), record.id(), TimeBucket.getTimestamp((long)record.getTimeBucket(), (DownSampling)model.getDownsampling()));
        BanyanDBConverter.StreamToStorage convert2Storage = new BanyanDBConverter.StreamToStorage(schema, streamWrite);
        this.storageBuilder.entity2Storage((StorageData)record, (Convert2Storage)convert2Storage);
        return new BanyanDBStreamInsertRequest((StreamWrite)convert2Storage.obtain());
    }

    @Generated
    public BanyanDBRecordDAO(StorageBuilder<Record> storageBuilder) {
        this.storageBuilder = storageBuilder;
    }
}

