/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb.stream;

import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.skywalking.banyandb.v1.client.AbstractQuery;
import org.apache.skywalking.banyandb.v1.client.RowEntity;
import org.apache.skywalking.banyandb.v1.client.StreamQuery;
import org.apache.skywalking.banyandb.v1.client.StreamQueryResponse;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.profiling.ebpf.storage.EBPFProfilingTargetType;
import org.apache.skywalking.oap.server.core.profiling.ebpf.storage.EBPFProfilingTaskRecord;
import org.apache.skywalking.oap.server.core.profiling.ebpf.storage.EBPFProfilingTriggerType;
import org.apache.skywalking.oap.server.core.query.type.EBPFProfilingTask;
import org.apache.skywalking.oap.server.core.storage.profiling.ebpf.IEBPFProfilingTaskDAO;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBConverter;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.AbstractBanyanDBDAO;

public class BanyanDBEBPFProfilingTaskDAO
extends AbstractBanyanDBDAO
implements IEBPFProfilingTaskDAO {
    private static final Set<String> TAGS = ImmutableSet.of((Object)"logical_id", (Object)"service_id", (Object)"instance_id", (Object)"process_labels_json", (Object)"trigger_type", (Object)"start_time", (Object[])new String[]{"fixed_trigger_duration", "target_type", "create_time", "last_update_time", "time_bucket"});
    private static final Gson GSON = new Gson();

    public BanyanDBEBPFProfilingTaskDAO(BanyanDBStorageClient client) {
        super(client);
    }

    public List<EBPFProfilingTask> queryTasksByServices(List<String> serviceIdList, final long taskStartTime, final long latestUpdateTime) throws IOException {
        ArrayList<EBPFProfilingTask> tasks = new ArrayList<EBPFProfilingTask>();
        for (final String serviceId : serviceIdList) {
            StreamQueryResponse resp = this.query("ebpf_profiling_task", TAGS, new AbstractBanyanDBDAO.QueryBuilder<StreamQuery>(){

                @Override
                protected void apply(StreamQuery query) {
                    query.and(this.eq("service_id", serviceId));
                    BanyanDBEBPFProfilingTaskDAO.this.appendTimeQuery(this, query, taskStartTime, latestUpdateTime);
                    query.setOrderBy(new AbstractQuery.OrderBy("create_time", AbstractQuery.Sort.DESC));
                }
            });
            tasks.addAll(resp.getElements().stream().map(this::buildTask).collect(Collectors.toList()));
        }
        return tasks;
    }

    public List<EBPFProfilingTask> queryTasksByTargets(final String serviceId, final String serviceInstanceId, List<EBPFProfilingTargetType> targetTypes, final long taskStartTime, final long latestUpdateTime) throws IOException {
        ArrayList<EBPFProfilingTask> tasks = new ArrayList<EBPFProfilingTask>();
        for (final EBPFProfilingTargetType targetType : targetTypes) {
            StreamQueryResponse resp = this.query("ebpf_profiling_task", TAGS, new AbstractBanyanDBDAO.QueryBuilder<StreamQuery>(){

                @Override
                protected void apply(StreamQuery query) {
                    if (StringUtil.isNotEmpty((String)serviceId)) {
                        query.and(this.eq("service_id", serviceId));
                    }
                    if (StringUtil.isNotEmpty((String)serviceInstanceId)) {
                        query.and(this.eq("instance_id", serviceInstanceId));
                    }
                    query.and(this.eq("target_type", targetType.value()));
                    BanyanDBEBPFProfilingTaskDAO.this.appendTimeQuery(this, query, taskStartTime, latestUpdateTime);
                    query.setOrderBy(new AbstractQuery.OrderBy("create_time", AbstractQuery.Sort.DESC));
                }
            });
            tasks.addAll(resp.getElements().stream().map(this::buildTask).collect(Collectors.toList()));
        }
        return tasks;
    }

    public EBPFProfilingTask queryById(final String id) throws IOException {
        StreamQueryResponse resp = this.query("ebpf_profiling_task", TAGS, new AbstractBanyanDBDAO.QueryBuilder<StreamQuery>(){

            @Override
            protected void apply(StreamQuery query) {
                query.and(this.eq("logical_id", id));
            }
        });
        List tasks = resp.getElements().stream().map(this::buildTask).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(tasks)) {
            return null;
        }
        EBPFProfilingTask result = (EBPFProfilingTask)tasks.get(0);
        for (int i = 1; i < tasks.size(); ++i) {
            result = result.combine((EBPFProfilingTask)tasks.get(i));
        }
        return result;
    }

    private void appendTimeQuery(AbstractBanyanDBDAO.QueryBuilder<StreamQuery> builder, StreamQuery query, long taskStartTime, long latestUpdateTime) {
        if (taskStartTime > 0L) {
            query.and(builder.gte("start_time", taskStartTime));
        }
        if (latestUpdateTime > 0L) {
            query.and(builder.gt("last_update_time", latestUpdateTime));
        }
    }

    private EBPFProfilingTask buildTask(RowEntity rowEntity) {
        EBPFProfilingTaskRecord.Builder builder = new EBPFProfilingTaskRecord.Builder();
        EBPFProfilingTaskRecord record = builder.storage2Entity((Convert2Entity)new BanyanDBConverter.StorageToStream("ebpf_profiling_task", rowEntity));
        EBPFProfilingTask task = new EBPFProfilingTask();
        task.setTaskId(record.getLogicalId());
        task.setServiceId(record.getServiceId());
        task.setServiceName(IDManager.ServiceID.analysisId((String)record.getServiceId()).getName());
        if (StringUtil.isNotEmpty((String)record.getProcessLabelsJson())) {
            task.setProcessLabels((List)GSON.fromJson(record.getProcessLabelsJson(), ArrayList.class));
        } else {
            task.setProcessLabels(Collections.emptyList());
        }
        if (StringUtil.isNotEmpty((String)record.getInstanceId())) {
            task.setServiceInstanceId(record.getInstanceId());
            task.setServiceInstanceName(IDManager.ServiceInstanceID.analysisId((String)record.getInstanceId()).getName());
        }
        task.setTaskStartTime(record.getStartTime());
        task.setTriggerType(EBPFProfilingTriggerType.valueOf((int)record.getTriggerType()));
        task.setFixedTriggerDuration(record.getFixedTriggerDuration());
        task.setTargetType(EBPFProfilingTargetType.valueOf((int)record.getTargetType()));
        task.setCreateTime(record.getCreateTime());
        task.setLastUpdateTime(record.getLastUpdateTime());
        return task;
    }
}

