/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb.stream;

import com.google.protobuf.GeneratedMessageV3;
import java.io.IOException;
import java.time.Instant;
import java.util.List;
import java.util.Set;
import org.apache.skywalking.banyandb.v1.client.AbstractQuery;
import org.apache.skywalking.banyandb.v1.client.MeasureQuery;
import org.apache.skywalking.banyandb.v1.client.MeasureQueryResponse;
import org.apache.skywalking.banyandb.v1.client.PairQueryCondition;
import org.apache.skywalking.banyandb.v1.client.StreamQuery;
import org.apache.skywalking.banyandb.v1.client.StreamQueryResponse;
import org.apache.skywalking.banyandb.v1.client.TimestampRange;
import org.apache.skywalking.oap.server.core.storage.AbstractDAO;
import org.apache.skywalking.oap.server.library.client.Client;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.MetadataRegistry;

public abstract class AbstractBanyanDBDAO
extends AbstractDAO<BanyanDBStorageClient> {
    private static final Instant UPPER_BOUND = Instant.ofEpochSecond(0L, Long.MAX_VALUE);
    private static final TimestampRange LARGEST_TIME_RANGE = new TimestampRange(0L, UPPER_BOUND.toEpochMilli());

    protected AbstractBanyanDBDAO(BanyanDBStorageClient client) {
        super((Client)client);
    }

    protected StreamQueryResponse query(String modelName, Set<String> tags, QueryBuilder<StreamQuery> builder) throws IOException {
        return this.query(modelName, tags, (TimestampRange)null, builder);
    }

    protected StreamQueryResponse query(String modelName, Set<String> tags, TimestampRange timestampRange, QueryBuilder<StreamQuery> builder) throws IOException {
        MetadataRegistry.Schema schema = MetadataRegistry.INSTANCE.findMetadata(modelName);
        if (schema == null) {
            throw new IllegalStateException("schema is not registered");
        }
        StreamQuery query = timestampRange == null ? new StreamQuery(schema.getMetadata().getGroup(), schema.getMetadata().getName(), LARGEST_TIME_RANGE, tags) : new StreamQuery(schema.getMetadata().getGroup(), schema.getMetadata().getName(), timestampRange, tags);
        builder.apply(query);
        return ((BanyanDBStorageClient)this.getClient()).query(query);
    }

    protected MeasureQueryResponse query(String modelName, Set<String> tags, Set<String> fields, QueryBuilder<MeasureQuery> builder) throws IOException {
        return this.query(modelName, tags, fields, null, builder);
    }

    protected MeasureQueryResponse query(String modelName, Set<String> tags, Set<String> fields, TimestampRange timestampRange, QueryBuilder<MeasureQuery> builder) throws IOException {
        MetadataRegistry.Schema schema = MetadataRegistry.INSTANCE.findMetadata(modelName);
        if (schema == null) {
            throw new IllegalStateException("schema is not registered");
        }
        MeasureQuery query = timestampRange == null ? new MeasureQuery(schema.getMetadata().getGroup(), schema.getMetadata().getName(), LARGEST_TIME_RANGE, tags, fields) : new MeasureQuery(schema.getMetadata().getGroup(), schema.getMetadata().getName(), timestampRange, tags, fields);
        builder.apply(query);
        return ((BanyanDBStorageClient)this.getClient()).query(query);
    }

    protected static QueryBuilder<MeasureQuery> emptyMeasureQuery() {
        return new QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
            }
        };
    }

    protected static abstract class QueryBuilder<T extends AbstractQuery<? extends GeneratedMessageV3>> {
        protected QueryBuilder() {
        }

        protected abstract void apply(T var1);

        protected PairQueryCondition<Long> eq(String name, long value) {
            return PairQueryCondition.LongQueryCondition.eq((String)name, (Long)value);
        }

        protected PairQueryCondition<List<String>> having(String name, List<String> value) {
            return PairQueryCondition.StringArrayQueryCondition.having((String)name, value);
        }

        protected PairQueryCondition<Long> lte(String name, long value) {
            return PairQueryCondition.LongQueryCondition.le((String)name, (Long)value);
        }

        protected PairQueryCondition<Long> gte(String name, long value) {
            return PairQueryCondition.LongQueryCondition.ge((String)name, (Long)value);
        }

        protected PairQueryCondition<Long> gt(String name, long value) {
            return PairQueryCondition.LongQueryCondition.gt((String)name, (Long)value);
        }

        protected PairQueryCondition<String> eq(String name, String value) {
            return PairQueryCondition.StringQueryCondition.eq((String)name, (String)value);
        }

        protected PairQueryCondition<Long> ne(String name, long value) {
            return PairQueryCondition.LongQueryCondition.ne((String)name, (Long)value);
        }
    }
}

