/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb.measure;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.skywalking.banyandb.v1.client.DataPoint;
import org.apache.skywalking.banyandb.v1.client.MeasureQuery;
import org.apache.skywalking.banyandb.v1.client.MeasureQueryResponse;
import org.apache.skywalking.banyandb.v1.client.TimestampRange;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.query.type.Call;
import org.apache.skywalking.oap.server.core.source.DetectPoint;
import org.apache.skywalking.oap.server.core.storage.query.ITopologyQueryDAO;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.AbstractBanyanDBDAO;

public class BanyanDBTopologyQueryDAO
extends AbstractBanyanDBDAO
implements ITopologyQueryDAO {
    public BanyanDBTopologyQueryDAO(BanyanDBStorageClient client) {
        super(client);
    }

    public List<Call.CallDetail> loadServiceRelationsDetectedAtServerSide(long startTB, long endTB, List<String> serviceIds) throws IOException {
        if (CollectionUtils.isEmpty(serviceIds)) {
            throw new UnexpectedException("Service id is empty");
        }
        List<AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>> queryBuilderList = this.buildServiceRelationsQueries(serviceIds);
        return this.queryServiceRelation(startTB, endTB, queryBuilderList, DetectPoint.SERVER);
    }

    public List<Call.CallDetail> loadServiceRelationDetectedAtClientSide(long startTB, long endTB, List<String> serviceIds) throws IOException {
        if (CollectionUtils.isEmpty(serviceIds)) {
            throw new UnexpectedException("Service id is empty");
        }
        List<AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>> queryBuilderList = this.buildServiceRelationsQueries(serviceIds);
        return this.queryServiceRelation(startTB, endTB, queryBuilderList, DetectPoint.CLIENT);
    }

    public List<Call.CallDetail> loadServiceRelationsDetectedAtServerSide(long startTB, long endTB) throws IOException {
        return this.queryServiceRelation(startTB, endTB, Collections.singletonList(BanyanDBTopologyQueryDAO.emptyMeasureQuery()), DetectPoint.SERVER);
    }

    public List<Call.CallDetail> loadServiceRelationDetectedAtClientSide(long startTB, long endTB) throws IOException {
        return this.queryServiceRelation(startTB, endTB, Collections.singletonList(BanyanDBTopologyQueryDAO.emptyMeasureQuery()), DetectPoint.CLIENT);
    }

    private List<AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>> buildServiceRelationsQueries(List<String> serviceIds) {
        ArrayList<AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>> queryBuilderList = new ArrayList<AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>>(serviceIds.size());
        for (final String serviceId : serviceIds) {
            queryBuilderList.add(new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

                @Override
                protected void apply(MeasureQuery query) {
                    query.and(this.eq("source_service_id", serviceId));
                }
            });
            queryBuilderList.add(new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

                @Override
                protected void apply(MeasureQuery query) {
                    query.and(this.eq("dest_service_id", serviceId));
                }
            });
        }
        return queryBuilderList;
    }

    List<Call.CallDetail> queryServiceRelation(long startTB, long endTB, List<AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>> queryBuilderList, DetectPoint detectPoint) throws IOException {
        TimestampRange timestampRange = null;
        if (startTB > 0L && endTB > 0L) {
            timestampRange = new TimestampRange(TimeBucket.getTimestamp((long)startTB), TimeBucket.getTimestamp((long)endTB));
        }
        String modelName = detectPoint == DetectPoint.SERVER ? "service_relation_server_side" : "service_relation_client_side";
        HashMap<String, Call.CallDetail> callMap = new HashMap<String, Call.CallDetail>();
        for (AbstractBanyanDBDAO.QueryBuilder<MeasureQuery> q : queryBuilderList) {
            MeasureQueryResponse resp = this.query(modelName, (Set<String>)ImmutableSet.of((Object)"component_id", (Object)"source_service_id", (Object)"dest_service_id", (Object)"entity_id"), Collections.emptySet(), timestampRange, q);
            if (resp.size() == 0) continue;
            Call.CallDetail call = new Call.CallDetail();
            String entityId = (String)((DataPoint)resp.getDataPoints().get(0)).getTagValue("entity_id");
            int componentId = ((Number)((DataPoint)resp.getDataPoints().get(0)).getTagValue("component_id")).intValue();
            call.buildFromServiceRelation(entityId, componentId, detectPoint);
            callMap.putIfAbsent(entityId, call);
        }
        return new ArrayList<Call.CallDetail>(callMap.values());
    }

    public List<Call.CallDetail> loadInstanceRelationDetectedAtServerSide(String clientServiceId, String serverServiceId, long startTB, long endTB) throws IOException {
        List<AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>> queryBuilderList = this.buildInstanceRelationsQueries(clientServiceId, serverServiceId);
        return this.queryInstanceRelation(startTB, endTB, queryBuilderList, DetectPoint.SERVER);
    }

    public List<Call.CallDetail> loadInstanceRelationDetectedAtClientSide(String clientServiceId, String serverServiceId, long startTB, long endTB) throws IOException {
        List<AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>> queryBuilderList = this.buildInstanceRelationsQueries(clientServiceId, serverServiceId);
        return this.queryInstanceRelation(startTB, endTB, queryBuilderList, DetectPoint.CLIENT);
    }

    private List<AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>> buildInstanceRelationsQueries(final String clientServiceId, final String serverServiceId) {
        ArrayList<AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>> queryBuilderList = new ArrayList<AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>>(2);
        queryBuilderList.add(new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
                query.and(this.eq("source_service_id", clientServiceId)).and(this.eq("dest_service_id", serverServiceId));
            }
        });
        queryBuilderList.add(new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
                query.and(this.eq("dest_service_id", clientServiceId)).and(this.eq("source_service_id", serverServiceId));
            }
        });
        return queryBuilderList;
    }

    List<Call.CallDetail> queryInstanceRelation(long startTB, long endTB, List<AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>> queryBuilderList, DetectPoint detectPoint) throws IOException {
        TimestampRange timestampRange = null;
        if (startTB > 0L && endTB > 0L) {
            timestampRange = new TimestampRange(TimeBucket.getTimestamp((long)startTB), TimeBucket.getTimestamp((long)endTB));
        }
        String modelName = detectPoint == DetectPoint.SERVER ? "service_instance_relation_server_side" : "service_instance_relation_client_side";
        HashMap<String, Call.CallDetail> callMap = new HashMap<String, Call.CallDetail>();
        for (AbstractBanyanDBDAO.QueryBuilder<MeasureQuery> q : queryBuilderList) {
            MeasureQueryResponse resp = this.query(modelName, (Set<String>)ImmutableSet.of((Object)"component_id", (Object)"source_service_id", (Object)"dest_service_id", (Object)"entity_id"), Collections.emptySet(), timestampRange, q);
            if (resp.size() == 0) continue;
            Call.CallDetail call = new Call.CallDetail();
            String entityId = (String)((DataPoint)resp.getDataPoints().get(0)).getTagValue("entity_id");
            int componentId = ((Number)((DataPoint)resp.getDataPoints().get(0)).getTagValue("component_id")).intValue();
            call.buildFromInstanceRelation(entityId, componentId, detectPoint);
            callMap.putIfAbsent(entityId, call);
        }
        return new ArrayList<Call.CallDetail>(callMap.values());
    }

    public List<Call.CallDetail> loadEndpointRelation(long startTB, long endTB, String destEndpointId) throws IOException {
        List<AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>> queryBuilderList = this.buildEndpointRelationsQueries(destEndpointId);
        return this.queryEndpointRelation(startTB, endTB, queryBuilderList, DetectPoint.SERVER);
    }

    public List<Call.CallDetail> loadProcessRelationDetectedAtClientSide(String serviceInstanceId, long startTB, long endTB) throws IOException {
        return this.queryProcessRelation(startTB, endTB, serviceInstanceId, DetectPoint.CLIENT);
    }

    public List<Call.CallDetail> loadProcessRelationDetectedAtServerSide(String serviceInstanceId, long startTB, long endTB) throws IOException {
        return this.queryProcessRelation(startTB, endTB, serviceInstanceId, DetectPoint.SERVER);
    }

    private List<AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>> buildEndpointRelationsQueries(final String destEndpointId) {
        ArrayList<AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>> queryBuilderList = new ArrayList<AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>>(2);
        queryBuilderList.add(new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
                query.and(this.eq("source_endpoint", destEndpointId));
            }
        });
        queryBuilderList.add(new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
                query.and(this.eq("dest_endpoint", destEndpointId));
            }
        });
        return queryBuilderList;
    }

    List<Call.CallDetail> queryEndpointRelation(long startTB, long endTB, List<AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>> queryBuilderList, DetectPoint detectPoint) throws IOException {
        TimestampRange timestampRange = null;
        if (startTB > 0L && endTB > 0L) {
            timestampRange = new TimestampRange(TimeBucket.getTimestamp((long)startTB), TimeBucket.getTimestamp((long)endTB));
        }
        HashMap<String, Call.CallDetail> callMap = new HashMap<String, Call.CallDetail>();
        for (AbstractBanyanDBDAO.QueryBuilder<MeasureQuery> q : queryBuilderList) {
            MeasureQueryResponse resp = this.query("endpoint_relation_server_side", (Set<String>)ImmutableSet.of((Object)"dest_endpoint", (Object)"source_endpoint", (Object)"entity_id"), Collections.emptySet(), timestampRange, q);
            if (resp.size() == 0) continue;
            Call.CallDetail call = new Call.CallDetail();
            String entityId = (String)((DataPoint)resp.getDataPoints().get(0)).getTagValue("entity_id");
            call.buildFromEndpointRelation(entityId, detectPoint);
            callMap.putIfAbsent(entityId, call);
        }
        return new ArrayList<Call.CallDetail>(callMap.values());
    }

    List<Call.CallDetail> queryProcessRelation(long startTB, long endTB, final String serviceInstanceId, DetectPoint detectPoint) throws IOException {
        TimestampRange timestampRange = null;
        if (startTB > 0L && endTB > 0L) {
            timestampRange = new TimestampRange(TimeBucket.getTimestamp((long)startTB), TimeBucket.getTimestamp((long)endTB));
        }
        String modelName = detectPoint == DetectPoint.SERVER ? "process_relation_server_side" : "process_relation_client_side";
        HashMap<String, Call.CallDetail> callMap = new HashMap<String, Call.CallDetail>();
        MeasureQueryResponse resp = this.query(modelName, (Set<String>)ImmutableSet.of((Object)"entity_id", (Object)"component_id"), Collections.emptySet(), timestampRange, new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
                query.and(this.eq("service_instance_id", serviceInstanceId));
            }
        });
        Call.CallDetail call = new Call.CallDetail();
        String entityId = (String)((DataPoint)resp.getDataPoints().get(0)).getTagValue("entity_id");
        int componentId = ((Number)((DataPoint)resp.getDataPoints().get(0)).getTagValue("component_id")).intValue();
        call.buildProcessRelation(entityId, componentId, detectPoint);
        callMap.putIfAbsent(entityId, call);
        return new ArrayList<Call.CallDetail>(callMap.values());
    }
}

