/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb.measure;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.skywalking.banyandb.v1.client.DataPoint;
import org.apache.skywalking.banyandb.v1.client.MeasureQuery;
import org.apache.skywalking.banyandb.v1.client.MeasureQueryResponse;
import org.apache.skywalking.banyandb.v1.client.TimestampRange;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.analysis.manual.searchtag.TagType;
import org.apache.skywalking.oap.server.core.storage.query.ITagAutoCompleteQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.AbstractBanyanDBDAO;

public class BanyanDBTagAutocompleteQueryDAO
extends AbstractBanyanDBDAO
implements ITagAutoCompleteQueryDAO {
    private static final Set<String> TAGS_KEY = ImmutableSet.of((Object)"tag_type", (Object)"tag_key");
    private static final Set<String> TAGS_KV = ImmutableSet.of((Object)"tag_type", (Object)"tag_key", (Object)"tag_value");

    public BanyanDBTagAutocompleteQueryDAO(BanyanDBStorageClient client) {
        super(client);
    }

    public Set<String> queryTagAutocompleteKeys(final TagType tagType, final int limit, long startSecondTB, long endSecondTB) throws IOException {
        MeasureQueryResponse resp;
        TimestampRange range = null;
        if (startSecondTB > 0L && endSecondTB > 0L) {
            range = new TimestampRange(TimeBucket.getTimestamp((long)startSecondTB), TimeBucket.getTimestamp((long)endSecondTB));
        }
        if ((resp = this.query("tag_autocomplete", TAGS_KEY, Collections.emptySet(), range, new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
                query.groupBy((Set)ImmutableSet.of((Object)"tag_key"));
                query.setLimit(Integer.valueOf(limit));
                query.and(this.eq("tag_type", tagType.name()));
            }
        })).size() == 0) {
            return Collections.emptySet();
        }
        HashSet<String> keys = new HashSet<String>();
        for (DataPoint dp : resp.getDataPoints()) {
            keys.add((String)dp.getTagValue("tag_key"));
        }
        return keys;
    }

    public Set<String> queryTagAutocompleteValues(final TagType tagType, final String tagKey, final int limit, long startSecondTB, long endSecondTB) throws IOException {
        MeasureQueryResponse resp;
        TimestampRange range = null;
        if (startSecondTB > 0L && endSecondTB > 0L) {
            range = new TimestampRange(TimeBucket.getTimestamp((long)startSecondTB), TimeBucket.getTimestamp((long)endSecondTB));
        }
        if ((resp = this.query("tag_autocomplete", TAGS_KV, Collections.emptySet(), range, new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
                query.groupBy((Set)ImmutableSet.of((Object)"tag_value"));
                query.setLimit(Integer.valueOf(limit));
                query.and(this.eq("tag_type", tagType.name()));
                query.and(this.eq("tag_key", tagKey));
            }
        })).size() == 0) {
            return Collections.emptySet();
        }
        HashSet<String> values = new HashSet<String>();
        for (DataPoint dp : resp.getDataPoints()) {
            values.add((String)dp.getTagValue("tag_value"));
        }
        return values;
    }
}

