/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb.measure;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.skywalking.banyandb.v1.client.DataPoint;
import org.apache.skywalking.banyandb.v1.client.MeasureQuery;
import org.apache.skywalking.banyandb.v1.client.MeasureQueryResponse;
import org.apache.skywalking.banyandb.v1.client.TimestampRange;
import org.apache.skywalking.oap.server.core.analysis.metrics.DataTable;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.input.MetricsCondition;
import org.apache.skywalking.oap.server.core.query.sql.Function;
import org.apache.skywalking.oap.server.core.query.type.HeatMap;
import org.apache.skywalking.oap.server.core.query.type.IntValues;
import org.apache.skywalking.oap.server.core.query.type.KVInt;
import org.apache.skywalking.oap.server.core.query.type.MetricsValues;
import org.apache.skywalking.oap.server.core.storage.annotation.ValueColumnMetadata;
import org.apache.skywalking.oap.server.core.storage.query.IMetricsQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.MetadataRegistry;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.AbstractBanyanDBDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.util.ByteUtil;

public class BanyanDBMetricsQueryDAO
extends AbstractBanyanDBDAO
implements IMetricsQueryDAO {
    public BanyanDBMetricsQueryDAO(BanyanDBStorageClient client) {
        super(client);
    }

    public long readMetricsValue(final MetricsCondition condition, final String valueColumnName, Duration duration) throws IOException {
        int defaultValue = ValueColumnMetadata.INSTANCE.getDefaultValue(condition.getName());
        final Function function = ValueColumnMetadata.INSTANCE.getValueFunction(condition.getName());
        if (function == Function.Latest) {
            return this.readMetricsValues(condition, valueColumnName, duration).getValues().latestValue(defaultValue);
        }
        String modelName = condition.getName();
        TimestampRange timestampRange = new TimestampRange(duration.getStartTimestamp(), duration.getEndTimestamp());
        MeasureQueryResponse resp = this.query(modelName, (Set<String>)ImmutableSet.of((Object)"entity_id"), (Set<String>)ImmutableSet.of((Object)valueColumnName), timestampRange, new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
                BanyanDBMetricsQueryDAO.this.buildAggregationQuery(query, valueColumnName, function);
                if (condition.getEntity().buildId() != null) {
                    query.and(this.eq("entity_id", condition.getEntity().buildId()));
                }
            }
        });
        Iterator iterator = resp.getDataPoints().iterator();
        if (iterator.hasNext()) {
            DataPoint dataPoint = (DataPoint)iterator.next();
            return ((Number)dataPoint.getFieldValue(valueColumnName)).longValue();
        }
        return defaultValue;
    }

    private void buildAggregationQuery(MeasureQuery query, String valueColumnName, Function function) {
        switch (function) {
            case Sum: {
                query.sumBy(valueColumnName, Collections.singleton("entity_id"));
                break;
            }
            default: {
                query.meanBy(valueColumnName, Collections.singleton("entity_id"));
            }
        }
    }

    public MetricsValues readMetricsValues(MetricsCondition condition, String valueColumnName, Duration duration) throws IOException {
        String modelName = condition.getName();
        MetadataRegistry.Schema schema = MetadataRegistry.INSTANCE.findMetadata(modelName);
        if (schema == null) {
            throw new IOException("schema is not registered");
        }
        List pointOfTimes = duration.assembleDurationPoints();
        List<String> ids = pointOfTimes.stream().map(pointOfTime -> {
            String id = pointOfTime.id(condition.getEntity().buildId());
            return id;
        }).collect(Collectors.toList());
        MetricsValues metricsValues = new MetricsValues();
        Map<String, DataPoint> idMap = this.queryIDs(modelName, valueColumnName, ids);
        if (!idMap.isEmpty()) {
            IntValues intValues = metricsValues.getValues();
            for (String id : ids) {
                KVInt kvInt = new KVInt();
                kvInt.setId(id);
                kvInt.setValue(0L);
                if (idMap.containsKey(id)) {
                    DataPoint dataPoint = idMap.get(id);
                    kvInt.setValue(this.extractFieldValue(schema, valueColumnName, dataPoint));
                } else {
                    kvInt.setValue((long)ValueColumnMetadata.INSTANCE.getDefaultValue(condition.getName()));
                }
                intValues.addKVInt(kvInt);
            }
        }
        metricsValues.setValues(IMetricsQueryDAO.Util.sortValues((IntValues)metricsValues.getValues(), ids, (int)ValueColumnMetadata.INSTANCE.getDefaultValue(condition.getName())));
        return metricsValues;
    }

    private long extractFieldValue(MetadataRegistry.Schema schema, String fieldName, DataPoint dataPoint) throws IOException {
        MetadataRegistry.ColumnSpec spec = schema.getSpec(fieldName);
        if (spec == null) {
            throw new IOException("field is not registered");
        }
        if (Double.TYPE.equals(spec.getColumnClass())) {
            return ByteUtil.bytes2Double((byte[])dataPoint.getFieldValue(fieldName)).longValue();
        }
        return ((Number)dataPoint.getFieldValue(fieldName)).longValue();
    }

    public List<MetricsValues> readLabeledMetricsValues(MetricsCondition condition, String valueColumnName, List<String> labels, Duration duration) throws IOException {
        List pointOfTimes = duration.assembleDurationPoints();
        String modelName = condition.getName();
        ArrayList<String> ids = new ArrayList<String>(pointOfTimes.size());
        pointOfTimes.forEach(pointOfTime -> {
            String id = pointOfTime.id(condition.getEntity().buildId());
            ids.add(id);
        });
        Map<String, DataPoint> idMap = this.queryIDs(modelName, valueColumnName, ids);
        HashMap<String, DataTable> dataTableMap = new HashMap<String, DataTable>(idMap.size());
        for (Map.Entry<String, DataPoint> entry : idMap.entrySet()) {
            dataTableMap.put(entry.getKey(), new DataTable((String)entry.getValue().getFieldValue(valueColumnName)));
        }
        return IMetricsQueryDAO.Util.composeLabelValue((MetricsCondition)condition, labels, ids, dataTableMap);
    }

    public HeatMap readHeatMap(MetricsCondition condition, String valueColumnName, Duration duration) throws IOException {
        List pointOfTimes = duration.assembleDurationPoints();
        String modelName = condition.getName();
        ArrayList<String> ids = new ArrayList<String>(pointOfTimes.size());
        pointOfTimes.forEach(pointOfTime -> {
            String id = pointOfTime.id(condition.getEntity().buildId());
            ids.add(id);
        });
        HeatMap heatMap = new HeatMap();
        Map<String, DataPoint> idMap = this.queryIDs(modelName, valueColumnName, ids);
        if (idMap.isEmpty()) {
            return heatMap;
        }
        int defaultValue = ValueColumnMetadata.INSTANCE.getDefaultValue(condition.getName());
        for (String id : ids) {
            DataPoint dataPoint = idMap.get(id);
            if (dataPoint == null) continue;
            String value = (String)dataPoint.getFieldValue("dataset");
            heatMap.buildColumn(id, value, defaultValue);
        }
        heatMap.fixMissingColumns(ids, defaultValue);
        return heatMap;
    }

    private Map<String, DataPoint> queryIDs(String modelName, String valueColumnName, List<String> measureIDs) throws IOException {
        HashMap<String, DataPoint> map = new HashMap<String, DataPoint>(measureIDs.size());
        for (final String id : measureIDs) {
            MeasureQueryResponse resp = this.query(modelName, Collections.emptySet(), (Set<String>)ImmutableSet.of((Object)valueColumnName), new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

                @Override
                protected void apply(MeasureQuery query) {
                    query.andWithID(id);
                }
            });
            if (resp.size() <= 0) continue;
            map.putIfAbsent(((DataPoint)resp.getDataPoints().get(0)).getId(), (DataPoint)resp.getDataPoints().get(0));
        }
        return map;
    }
}

