/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb.measure;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.banyandb.v1.client.DataPoint;
import org.apache.skywalking.banyandb.v1.client.MeasureQuery;
import org.apache.skywalking.banyandb.v1.client.MeasureQueryResponse;
import org.apache.skywalking.banyandb.v1.client.MeasureWrite;
import org.apache.skywalking.oap.server.core.analysis.DownSampling;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.storage.IMetricsDAO;
import org.apache.skywalking.oap.server.core.storage.StorageData;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;
import org.apache.skywalking.oap.server.library.client.request.InsertRequest;
import org.apache.skywalking.oap.server.library.client.request.UpdateRequest;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBConverter;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.MetadataRegistry;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.measure.BanyanDBMeasureInsertRequest;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.measure.BanyanDBMeasureUpdateRequest;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.AbstractBanyanDBDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BanyanDBMetricsDAO
extends AbstractBanyanDBDAO
implements IMetricsDAO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BanyanDBMetricsDAO.class);
    private final StorageBuilder<Metrics> storageBuilder;

    public BanyanDBMetricsDAO(BanyanDBStorageClient client, StorageBuilder<Metrics> storageBuilder) {
        super(client);
        this.storageBuilder = storageBuilder;
    }

    public List<Metrics> multiGet(Model model, List<Metrics> metrics) throws IOException {
        log.info("multiGet {} from BanyanDB", (Object)model.getName());
        MetadataRegistry.Schema schema = MetadataRegistry.INSTANCE.findMetadata(model.getName());
        if (schema == null) {
            throw new IOException(model.getName() + " is not registered");
        }
        ArrayList<Metrics> metricsInStorage = new ArrayList<Metrics>(metrics.size());
        for (final Metrics missCachedMetric : metrics) {
            MeasureQueryResponse resp = this.query(model.getName(), schema.getTags(), schema.getFields(), new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

                @Override
                protected void apply(MeasureQuery query) {
                    query.andWithID(missCachedMetric.id());
                }
            });
            if (resp.size() == 0) continue;
            for (DataPoint dataPoint : resp.getDataPoints()) {
                metricsInStorage.add((Metrics)this.storageBuilder.storage2Entity((Convert2Entity)new BanyanDBConverter.StorageToMeasure(model.getName(), dataPoint)));
            }
        }
        return metricsInStorage;
    }

    public InsertRequest prepareBatchInsert(Model model, Metrics metrics) throws IOException {
        log.info("prepare to insert {}", (Object)model.getName());
        MetadataRegistry.Schema schema = MetadataRegistry.INSTANCE.findMetadata(model.getName());
        if (schema == null) {
            throw new IOException(model.getName() + " is not registered");
        }
        MeasureWrite measureWrite = new MeasureWrite(schema.getMetadata().getGroup(), model.getName(), TimeBucket.getTimestamp((long)metrics.getTimeBucket(), (DownSampling)model.getDownsampling()));
        BanyanDBConverter.MeasureToStorage toStorage = new BanyanDBConverter.MeasureToStorage(schema, measureWrite);
        this.storageBuilder.entity2Storage((StorageData)metrics, (Convert2Storage)toStorage);
        toStorage.acceptID(metrics.id());
        return new BanyanDBMeasureInsertRequest(toStorage.obtain());
    }

    public UpdateRequest prepareBatchUpdate(Model model, Metrics metrics) throws IOException {
        log.info("prepare to update {}", (Object)model.getName());
        MetadataRegistry.Schema schema = MetadataRegistry.INSTANCE.findMetadata(model.getName());
        if (schema == null) {
            throw new IOException(model.getName() + " is not registered");
        }
        MeasureWrite measureWrite = new MeasureWrite(schema.getMetadata().getGroup(), model.getName(), TimeBucket.getTimestamp((long)metrics.getTimeBucket(), (DownSampling)model.getDownsampling()));
        BanyanDBConverter.MeasureToStorage toStorage = new BanyanDBConverter.MeasureToStorage(schema, measureWrite);
        this.storageBuilder.entity2Storage((StorageData)metrics, (Convert2Storage)toStorage);
        toStorage.acceptID(metrics.id());
        return new BanyanDBMeasureUpdateRequest(toStorage.obtain());
    }
}

