/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb.measure;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.skywalking.banyandb.v1.client.DataPoint;
import org.apache.skywalking.banyandb.v1.client.MeasureQuery;
import org.apache.skywalking.banyandb.v1.client.MeasureQueryResponse;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.analysis.manual.process.ProcessDetectType;
import org.apache.skywalking.oap.server.core.query.enumeration.Language;
import org.apache.skywalking.oap.server.core.query.enumeration.ProfilingSupportStatus;
import org.apache.skywalking.oap.server.core.query.type.Attribute;
import org.apache.skywalking.oap.server.core.query.type.Endpoint;
import org.apache.skywalking.oap.server.core.query.type.Process;
import org.apache.skywalking.oap.server.core.query.type.Service;
import org.apache.skywalking.oap.server.core.query.type.ServiceInstance;
import org.apache.skywalking.oap.server.core.storage.query.IMetadataQueryDAO;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.AbstractBanyanDBDAO;

public class BanyanDBMetadataQueryDAO
extends AbstractBanyanDBDAO
implements IMetadataQueryDAO {
    private static final Set<String> SERVICE_TRAFFIC_TAGS = ImmutableSet.of((Object)"name", (Object)"short_name", (Object)"service_group", (Object)"layer", (Object)"service_id");
    private static final Set<String> INSTANCE_TRAFFIC_TAGS = ImmutableSet.of((Object)"name", (Object)"properties", (Object)"last_ping", (Object)"service_id");
    private static final Set<String> INSTANCE_TRAFFIC_COMPACT_TAGS = ImmutableSet.of((Object)"name", (Object)"properties");
    private static final Set<String> ENDPOINT_TRAFFIC_TAGS = ImmutableSet.of((Object)"name", (Object)"service_id");
    private static final Set<String> PROCESS_TRAFFIC_TAGS = ImmutableSet.of((Object)"name", (Object)"service_id", (Object)"instance_id", (Object)"agent_id", (Object)"detect_type", (Object)"properties", (Object[])new String[]{"labels_json", "last_ping", "profiling_support_status"});
    private static final Set<String> PROCESS_TRAFFIC_COMPACT_TAGS = ImmutableSet.of((Object)"name", (Object)"service_id", (Object)"instance_id", (Object)"agent_id", (Object)"detect_type", (Object)"properties", (Object[])new String[]{"labels_json"});
    private static final Gson GSON = new Gson();

    public BanyanDBMetadataQueryDAO(BanyanDBStorageClient client) {
        super(client);
    }

    public List<Service> listServices(final String layer, final String group) throws IOException {
        MeasureQueryResponse resp = this.query("service_traffic", SERVICE_TRAFFIC_TAGS, Collections.emptySet(), new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
                if (StringUtil.isNotEmpty((String)group)) {
                    query.and(this.eq("service_group", group));
                }
                if (StringUtil.isNotEmpty((String)layer)) {
                    query.and(this.eq("layer", Layer.valueOf((String)layer).value()));
                }
            }
        });
        ArrayList<Service> services = new ArrayList<Service>();
        for (DataPoint dataPoint : resp.getDataPoints()) {
            services.add(this.buildService(dataPoint));
        }
        return services;
    }

    public List<Service> getServices(final String serviceId) throws IOException {
        MeasureQueryResponse resp = this.query("service_traffic", SERVICE_TRAFFIC_TAGS, Collections.emptySet(), new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
                if (StringUtil.isNotEmpty((String)serviceId)) {
                    query.and(this.eq("service_id", serviceId));
                }
            }
        });
        ArrayList<Service> services = new ArrayList<Service>();
        for (DataPoint dataPoint : resp.getDataPoints()) {
            services.add(this.buildService(dataPoint));
        }
        return services;
    }

    public List<ServiceInstance> listInstances(final long startTimestamp, long endTimestamp, final String serviceId) throws IOException {
        MeasureQueryResponse resp = this.query("instance_traffic", INSTANCE_TRAFFIC_TAGS, Collections.emptySet(), new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
                if (StringUtil.isNotEmpty((String)serviceId)) {
                    query.and(this.eq("service_id", serviceId));
                }
                long minuteTimeBucket = TimeBucket.getMinuteTimeBucket((long)startTimestamp);
                query.and(this.gte("last_ping", minuteTimeBucket));
            }
        });
        ArrayList<ServiceInstance> instances = new ArrayList<ServiceInstance>();
        for (DataPoint dataPoint : resp.getDataPoints()) {
            instances.add(this.buildInstance(dataPoint));
        }
        return instances;
    }

    public ServiceInstance getInstance(final String instanceId) throws IOException {
        MeasureQueryResponse resp = this.query("instance_traffic", INSTANCE_TRAFFIC_COMPACT_TAGS, Collections.emptySet(), new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
                if (StringUtil.isNotEmpty((String)instanceId)) {
                    query.andWithID(instanceId);
                }
            }
        });
        return resp.size() > 0 ? this.buildInstance((DataPoint)resp.getDataPoints().get(0)) : null;
    }

    public List<Endpoint> findEndpoint(String keyword, final String serviceId, int limit) throws IOException {
        MeasureQueryResponse resp = this.query("endpoint_traffic", ENDPOINT_TRAFFIC_TAGS, Collections.emptySet(), new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
                if (StringUtil.isNotEmpty((String)serviceId)) {
                    query.and(this.eq("service_id", serviceId));
                }
            }
        });
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        for (DataPoint dataPoint : resp.getDataPoints()) {
            endpoints.add(this.buildEndpoint(dataPoint));
        }
        if (StringUtil.isNotEmpty((String)serviceId)) {
            return endpoints.stream().filter(e -> e.getName().contains(keyword)).collect(Collectors.toList());
        }
        return endpoints;
    }

    public List<Process> listProcesses(final String serviceId, final ProfilingSupportStatus supportStatus, final long lastPingStartTimeBucket, long lastPingEndTimeBucket) throws IOException {
        MeasureQueryResponse resp = this.query("process_traffic", PROCESS_TRAFFIC_TAGS, Collections.emptySet(), new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
                query.and(this.eq("service_id", serviceId));
                query.and(this.gte("last_ping", lastPingStartTimeBucket));
                query.and(this.eq("profiling_support_status", supportStatus.value()));
                query.and(this.ne("detect_type", ProcessDetectType.VIRTUAL.value()));
            }
        });
        ArrayList<Process> processes = new ArrayList<Process>();
        for (DataPoint dataPoint : resp.getDataPoints()) {
            processes.add(this.buildProcess(dataPoint));
        }
        return processes;
    }

    public List<Process> listProcesses(final String serviceInstanceId, final long lastPingStartTimeBucket, long lastPingEndTimeBucket, final boolean includeVirtual) throws IOException {
        MeasureQueryResponse resp = this.query("process_traffic", PROCESS_TRAFFIC_TAGS, Collections.emptySet(), new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
                query.and(this.eq("instance_id", serviceInstanceId));
                query.and(this.gte("last_ping", lastPingStartTimeBucket));
                if (!includeVirtual) {
                    query.and(this.ne("detect_type", ProcessDetectType.VIRTUAL.value()));
                }
            }
        });
        ArrayList<Process> processes = new ArrayList<Process>();
        for (DataPoint dataPoint : resp.getDataPoints()) {
            processes.add(this.buildProcess(dataPoint));
        }
        return processes;
    }

    public List<Process> listProcesses(final String agentId) throws IOException {
        MeasureQueryResponse resp = this.query("process_traffic", PROCESS_TRAFFIC_TAGS, Collections.emptySet(), new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
                query.and(this.eq("agent_id", agentId));
                query.and(this.ne("detect_type", ProcessDetectType.VIRTUAL.value()));
            }
        });
        ArrayList<Process> processes = new ArrayList<Process>();
        for (DataPoint dataPoint : resp.getDataPoints()) {
            processes.add(this.buildProcess(dataPoint));
        }
        return processes;
    }

    public long getProcessCount(final String serviceId, final ProfilingSupportStatus profilingSupportStatus, final long lastPingStartTimeBucket, long lastPingEndTimeBucket) throws IOException {
        MeasureQueryResponse resp = this.query("process_traffic", PROCESS_TRAFFIC_TAGS, Collections.emptySet(), new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
                query.and(this.eq("service_id", serviceId));
                query.and(this.gte("last_ping", lastPingStartTimeBucket));
                query.and(this.eq("profiling_support_status", profilingSupportStatus.value()));
                query.and(this.ne("detect_type", ProcessDetectType.VIRTUAL.value()));
            }
        });
        return resp.getDataPoints().stream().collect(Collectors.groupingBy(dataPoint -> (String)dataPoint.getTagValue("properties"))).size();
    }

    public long getProcessCount(final String instanceId) throws IOException {
        MeasureQueryResponse resp = this.query("process_traffic", PROCESS_TRAFFIC_TAGS, Collections.emptySet(), new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
                query.and(this.eq("instance_id", instanceId));
                query.and(this.ne("detect_type", ProcessDetectType.VIRTUAL.value()));
            }
        });
        return resp.getDataPoints().stream().collect(Collectors.groupingBy(dataPoint -> (String)dataPoint.getTagValue("properties"))).size();
    }

    public Process getProcess(final String processId) throws IOException {
        MeasureQueryResponse resp = this.query("process_traffic", PROCESS_TRAFFIC_COMPACT_TAGS, Collections.emptySet(), new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
                if (StringUtil.isNotEmpty((String)processId)) {
                    query.andWithID(processId);
                }
            }
        });
        return resp.size() > 0 ? this.buildProcess((DataPoint)resp.getDataPoints().get(0)) : null;
    }

    private Service buildService(DataPoint dataPoint) {
        Service service = new Service();
        service.setId((String)dataPoint.getTagValue("service_id"));
        service.setName((String)dataPoint.getTagValue("name"));
        service.setShortName((String)dataPoint.getTagValue("short_name"));
        service.setGroup((String)dataPoint.getTagValue("service_group"));
        service.getLayers().add(Layer.valueOf((int)((Number)dataPoint.getTagValue("layer")).intValue()).name());
        return service;
    }

    private ServiceInstance buildInstance(DataPoint dataPoint) {
        ServiceInstance serviceInstance = new ServiceInstance();
        serviceInstance.setId(dataPoint.getId());
        serviceInstance.setName((String)dataPoint.getTagValue("name"));
        serviceInstance.setInstanceUUID(dataPoint.getId());
        String propString = (String)dataPoint.getTagValue("properties");
        JsonObject properties = null;
        if (StringUtil.isNotEmpty((String)propString)) {
            properties = (JsonObject)GSON.fromJson(propString, JsonObject.class);
        }
        if (properties != null) {
            for (Map.Entry property : properties.entrySet()) {
                String key = (String)property.getKey();
                String value = ((JsonElement)property.getValue()).getAsString();
                if (key.equals("language")) {
                    serviceInstance.setLanguage(Language.value((String)value));
                    continue;
                }
                serviceInstance.getAttributes().add(new Attribute(key, value));
            }
        } else {
            serviceInstance.setLanguage(Language.UNKNOWN);
        }
        return serviceInstance;
    }

    private Endpoint buildEndpoint(DataPoint dataPoint) {
        Endpoint endpoint = new Endpoint();
        endpoint.setId(dataPoint.getId());
        endpoint.setName((String)dataPoint.getTagValue("name"));
        return endpoint;
    }

    private Process buildProcess(DataPoint dataPoint) {
        String labelJson;
        Process process = new Process();
        process.setId(dataPoint.getId());
        process.setName((String)dataPoint.getTagValue("name"));
        String serviceId = (String)dataPoint.getTagValue("service_id");
        process.setServiceId(serviceId);
        process.setServiceName(IDManager.ServiceID.analysisId((String)serviceId).getName());
        String instanceId = (String)dataPoint.getTagValue("instance_id");
        process.setInstanceId(instanceId);
        process.setInstanceName(IDManager.ServiceInstanceID.analysisId((String)instanceId).getName());
        process.setAgentId((String)dataPoint.getTagValue("agent_id"));
        process.setDetectType(ProcessDetectType.valueOf((int)((Number)dataPoint.getTagValue("detect_type")).intValue()).name());
        process.setProfilingSupportStatus(ProfilingSupportStatus.valueOf((int)((Number)dataPoint.getTagValue("profiling_support_status")).intValue()).name());
        String propString = (String)dataPoint.getTagValue("properties");
        if (!Strings.isNullOrEmpty((String)propString)) {
            JsonObject properties = (JsonObject)GSON.fromJson(propString, JsonObject.class);
            for (Map.Entry property : properties.entrySet()) {
                String key = (String)property.getKey();
                String value = ((JsonElement)property.getValue()).getAsString();
                process.getAttributes().add(new Attribute(key, value));
            }
        }
        if (!Strings.isNullOrEmpty((String)(labelJson = (String)dataPoint.getTagValue("labels_json")))) {
            List labels = (List)GSON.fromJson(labelJson, ArrayList.class);
            process.getLabels().addAll(labels);
        }
        return process;
    }
}

