/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb.measure;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.skywalking.banyandb.v1.client.DataPoint;
import org.apache.skywalking.banyandb.v1.client.MeasureQuery;
import org.apache.skywalking.banyandb.v1.client.MeasureQueryResponse;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.query.PaginationUtils;
import org.apache.skywalking.oap.server.core.query.enumeration.Order;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.type.event.Event;
import org.apache.skywalking.oap.server.core.query.type.event.EventQueryCondition;
import org.apache.skywalking.oap.server.core.query.type.event.EventType;
import org.apache.skywalking.oap.server.core.query.type.event.Events;
import org.apache.skywalking.oap.server.core.query.type.event.Source;
import org.apache.skywalking.oap.server.core.storage.query.IEventQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.AbstractBanyanDBDAO;

public class BanyanDBEventQueryDAO
extends AbstractBanyanDBDAO
implements IEventQueryDAO {
    private static final Set<String> TAGS = ImmutableSet.of((Object)"uuid", (Object)"service", (Object)"service_instance", (Object)"endpoint", (Object)"name", (Object)"message", (Object[])new String[]{"type", "start_time", "end_time", "parameters", "layer"});

    public BanyanDBEventQueryDAO(BanyanDBStorageClient client) {
        super(client);
    }

    public Events queryEvents(final EventQueryCondition condition) throws Exception {
        MeasureQueryResponse resp = this.query("events", TAGS, Collections.emptySet(), new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
                Duration startTime;
                Source source;
                if (!Strings.isNullOrEmpty((String)condition.getUuid())) {
                    query.and(this.eq("uuid", condition.getUuid()));
                }
                if ((source = condition.getSource()) != null) {
                    if (!Strings.isNullOrEmpty((String)source.getService())) {
                        query.and(this.eq("service", source.getService()));
                    }
                    if (!Strings.isNullOrEmpty((String)source.getServiceInstance())) {
                        query.and(this.eq("service_instance", source.getServiceInstance()));
                    }
                    if (!Strings.isNullOrEmpty((String)source.getEndpoint())) {
                        query.and(this.eq("endpoint", source.getEndpoint()));
                    }
                }
                if (!Strings.isNullOrEmpty((String)condition.getName())) {
                    query.and(this.eq("name", condition.getName()));
                }
                if (condition.getType() != null) {
                    query.and(this.eq("type", condition.getType().name()));
                }
                if ((startTime = condition.getTime()) != null) {
                    if (startTime.getStartTimestamp() > 0L) {
                        query.and(this.gte("start_time", startTime.getStartTimestamp()));
                    }
                    if (startTime.getEndTimestamp() > 0L) {
                        query.and(this.lte("end_time", startTime.getEndTimestamp()));
                    }
                }
                if (!Strings.isNullOrEmpty((String)condition.getLayer())) {
                    query.and(this.eq("layer", Layer.valueOf((String)condition.getLayer()).value()));
                }
            }
        });
        Events events = new Events();
        if (resp.size() == 0) {
            return events;
        }
        for (DataPoint dataPoint : resp.getDataPoints()) {
            events.getEvents().add(this.buildEventView(dataPoint));
        }
        this.sortEvents(events, condition);
        return events;
    }

    public Events queryEvents(List<EventQueryCondition> conditionList) throws Exception {
        Events totalEvents = new Events();
        for (EventQueryCondition cond : conditionList) {
            Events singleEvents = this.queryEvents(cond);
            totalEvents.getEvents().addAll(singleEvents.getEvents());
        }
        return totalEvents;
    }

    protected Event buildEventView(DataPoint dataPoint) {
        Event event = new Event();
        event.setUuid((String)dataPoint.getTagValue("uuid"));
        String service = (String)dataPoint.getTagValue("service");
        String serviceInstance = (String)dataPoint.getTagValue("service_instance");
        String endpoint = (String)dataPoint.getTagValue("endpoint");
        event.setSource(new Source(service, serviceInstance, endpoint));
        event.setName((String)dataPoint.getTagValue("name"));
        event.setType(EventType.parse((String)((String)dataPoint.getTagValue("type"))));
        event.setMessage((String)dataPoint.getTagValue("message"));
        event.setParameters((String)dataPoint.getTagValue("parameters"));
        event.setStartTime(((Long)dataPoint.getTagValue("start_time")).longValue());
        event.setEndTime(((Long)dataPoint.getTagValue("end_time")).longValue());
        event.setLayer(Layer.valueOf((int)((Number)dataPoint.getTagValue("layer")).intValue()).name());
        return event;
    }

    private void sortEvents(Events events, EventQueryCondition condition) {
        if (events.getEvents().isEmpty()) {
            return;
        }
        Comparator<Event> c = this.buildComparator(Objects.isNull(condition.getOrder()) ? Order.DES : condition.getOrder());
        PaginationUtils.Page page = PaginationUtils.INSTANCE.exchange(condition.getPaging());
        events.setEvents(events.getEvents().stream().sorted(c).skip(page.getFrom()).limit(page.getLimit()).collect(Collectors.toList()));
    }

    private Comparator<Event> buildComparator(Order queryOrder) {
        Comparator<Event> c = Comparator.comparingLong(Event::getStartTime);
        if (queryOrder == Order.DES) {
            c = c.reversed();
        }
        return c;
    }
}

