/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb.measure;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.skywalking.banyandb.v1.client.AbstractQuery;
import org.apache.skywalking.banyandb.v1.client.DataPoint;
import org.apache.skywalking.banyandb.v1.client.MeasureQuery;
import org.apache.skywalking.banyandb.v1.client.MeasureQueryResponse;
import org.apache.skywalking.oap.server.core.query.type.EBPFProfilingSchedule;
import org.apache.skywalking.oap.server.core.storage.profiling.ebpf.IEBPFProfilingScheduleDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.AbstractBanyanDBDAO;

public class BanyanDBEBPFProfilingScheduleQueryDAO
extends AbstractBanyanDBDAO
implements IEBPFProfilingScheduleDAO {
    private static final Set<String> TAGS = ImmutableSet.of((Object)"start_time", (Object)"task_id", (Object)"process_id", (Object)"end_time");

    public BanyanDBEBPFProfilingScheduleQueryDAO(BanyanDBStorageClient client) {
        super(client);
    }

    public List<EBPFProfilingSchedule> querySchedules(final String taskId) throws IOException {
        MeasureQueryResponse resp = this.query("ebpf_profiling_schedule", TAGS, Collections.emptySet(), new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
                query.and(this.eq("task_id", taskId));
                query.setOrderBy(new AbstractQuery.OrderBy("start_time", AbstractQuery.Sort.DESC));
            }
        });
        return resp.getDataPoints().stream().map(this::buildEBPFProfilingSchedule).collect(Collectors.toList());
    }

    private EBPFProfilingSchedule buildEBPFProfilingSchedule(DataPoint dataPoint) {
        EBPFProfilingSchedule schedule = new EBPFProfilingSchedule();
        schedule.setScheduleId(dataPoint.getId());
        schedule.setTaskId((String)dataPoint.getTagValue("task_id"));
        schedule.setProcessId((String)dataPoint.getTagValue("process_id"));
        schedule.setStartTime(((Number)dataPoint.getTagValue("start_time")).longValue());
        schedule.setEndTime(((Number)dataPoint.getTagValue("end_time")).longValue());
        return schedule;
    }
}

