/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb;

import com.google.gson.JsonObject;
import io.grpc.Status;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.skywalking.banyandb.v1.client.BanyanDBClient;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.BanyanDBException;
import org.apache.skywalking.banyandb.v1.client.metadata.Catalog;
import org.apache.skywalking.banyandb.v1.client.metadata.Duration;
import org.apache.skywalking.banyandb.v1.client.metadata.Group;
import org.apache.skywalking.banyandb.v1.client.metadata.IndexRule;
import org.apache.skywalking.banyandb.v1.client.metadata.Measure;
import org.apache.skywalking.banyandb.v1.client.metadata.NamedSchema;
import org.apache.skywalking.banyandb.v1.client.metadata.Stream;
import org.apache.skywalking.banyandb.v1.client.metadata.TagFamilySpec;
import org.apache.skywalking.oap.server.core.analysis.DownSampling;
import org.apache.skywalking.oap.server.core.analysis.metrics.IntList;
import org.apache.skywalking.oap.server.core.storage.annotation.ValueColumnMetadata;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.storage.model.ModelColumn;
import org.apache.skywalking.oap.server.core.storage.type.StorageDataComplexObject;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum MetadataRegistry {
    INSTANCE;

    @Generated
    private static final Logger log;
    private final Map<String, Schema> registry = new HashMap<String, Schema>();

    public NamedSchema<?> registerModel(Model model, BanyanDBStorageConfig config) {
        Stream.Builder builder;
        SchemaMetadata schemaMetadata = this.parseMetadata(model, config);
        Schema.SchemaBuilder schemaBuilder = Schema.builder().metadata(schemaMetadata);
        Map<String, ModelColumn> modelColumnMap = model.getColumns().stream().collect(Collectors.toMap(modelColumn -> modelColumn.getColumnName().getStorageName(), Function.identity()));
        List<String> entities = this.parseEntityNames(modelColumnMap);
        List<TagMetadata> tags = this.parseTagMetadata(model, schemaBuilder);
        List tagFamilySpecs = schemaMetadata.extractTagFamilySpec(tags);
        for (TagFamilySpec tagFamilySpec : tagFamilySpecs) {
            for (TagFamilySpec.TagSpec tagSpec : tagFamilySpec.tagSpecs()) {
                schemaBuilder.tag(tagSpec.getTagName());
            }
        }
        List indexRules = tags.stream().map(TagMetadata::getIndexRule).filter(Objects::nonNull).collect(Collectors.toList());
        if (schemaMetadata.getKind() == Kind.STREAM) {
            builder = Stream.create((String)schemaMetadata.getGroup(), (String)schemaMetadata.getName());
            if (entities.isEmpty()) {
                throw new IllegalStateException("sharding keys of model[stream." + model.getName() + "] must not be empty");
            }
            builder.setEntityRelativeTags(entities);
            builder.addTagFamilies((Iterable)tagFamilySpecs);
            builder.addIndexes(indexRules);
            this.registry.put(model.getName(), schemaBuilder.build());
            return builder.build();
        }
        builder = Measure.create((String)schemaMetadata.getGroup(), (String)schemaMetadata.getName(), (Duration)this.downSamplingDuration(model.getDownsampling()));
        if (entities.isEmpty()) {
            builder.setEntityRelativeTags(new String[]{"id"});
        } else {
            builder.setEntityRelativeTags(entities);
        }
        builder.addTagFamilies((Iterable)tagFamilySpecs);
        builder.addIndexes(indexRules);
        Optional valueColumnOpt = ValueColumnMetadata.INSTANCE.readValueColumnDefinition(model.getName());
        valueColumnOpt.ifPresent(arg_0 -> this.lambda$registerModel$1((Measure.Builder)builder, modelColumnMap, arg_0));
        valueColumnOpt.ifPresent(valueColumn -> schemaBuilder.field(valueColumn.getValueCName()));
        this.registry.put(model.getName(), schemaBuilder.build());
        return builder.build();
    }

    public Schema findMetadata(String name) {
        return this.registry.get(name);
    }

    private Measure.FieldSpec parseFieldSpec(ModelColumn modelColumn, ValueColumnMetadata.ValueColumn valueColumn) {
        if (String.class.equals((Object)modelColumn.getType())) {
            return Measure.FieldSpec.newIntField((String)valueColumn.getValueCName()).compressWithZSTD().build();
        }
        if (Long.TYPE.equals(modelColumn.getType()) || Integer.TYPE.equals(modelColumn.getType())) {
            return Measure.FieldSpec.newIntField((String)valueColumn.getValueCName()).compressWithZSTD().encodeWithGorilla().build();
        }
        if (StorageDataComplexObject.class.isAssignableFrom(modelColumn.getType())) {
            return Measure.FieldSpec.newStringField((String)valueColumn.getValueCName()).compressWithZSTD().build();
        }
        if (Double.TYPE.equals(modelColumn.getType())) {
            log.warn("Double is stored as binary");
            return Measure.FieldSpec.newBinaryField((String)valueColumn.getValueCName()).compressWithZSTD().build();
        }
        throw new UnsupportedOperationException(modelColumn.getType().getSimpleName() + " is not supported for field");
    }

    Duration downSamplingDuration(DownSampling downSampling) {
        switch (downSampling) {
            case Hour: {
                return Duration.ofHours((long)1L);
            }
            case Minute: {
                return Duration.ofMinutes((long)1L);
            }
            case Day: {
                return Duration.ofDays((long)1L);
            }
        }
        throw new UnsupportedOperationException("unsupported downSampling interval");
    }

    IndexRule parseIndexRule(String tagName, ModelColumn modelColumn) {
        if (modelColumn == null) {
            return IndexRule.create((String)tagName, (IndexRule.IndexType)IndexRule.IndexType.INVERTED, (IndexRule.IndexLocation)IndexRule.IndexLocation.SERIES);
        }
        if (modelColumn.getBanyanDBExtension().isGlobalIndexing()) {
            return IndexRule.create((String)tagName, (IndexRule.IndexType)IndexRule.IndexType.INVERTED, (IndexRule.IndexLocation)IndexRule.IndexLocation.GLOBAL);
        }
        return IndexRule.create((String)tagName, (IndexRule.IndexType)IndexRule.IndexType.INVERTED, (IndexRule.IndexLocation)IndexRule.IndexLocation.SERIES);
    }

    List<String> parseEntityNames(Map<String, ModelColumn> modelColumnMap) {
        ArrayList<ModelColumn> shardingColumns = new ArrayList<ModelColumn>();
        for (ModelColumn col2 : modelColumnMap.values()) {
            if (!col2.getBanyanDBExtension().isShardingKey()) continue;
            shardingColumns.add(col2);
        }
        return shardingColumns.stream().sorted(Comparator.comparingInt(col -> col.getBanyanDBExtension().getShardingKeyIdx())).map(col -> col.getColumnName().getName()).collect(Collectors.toList());
    }

    List<TagMetadata> parseTagMetadata(Model model, Schema.SchemaBuilder builder) {
        ArrayList<TagMetadata> tagMetadataList = new ArrayList<TagMetadata>();
        Optional valueColumnOpt = ValueColumnMetadata.INSTANCE.readValueColumnDefinition(model.getName());
        for (ModelColumn col : model.getColumns()) {
            if (valueColumnOpt.isPresent() && ((ValueColumnMetadata.ValueColumn)valueColumnOpt.get()).getValueCName().equals(col.getColumnName().getStorageName())) {
                builder.spec(col.getColumnName().getStorageName(), new ColumnSpec(ColumnType.FIELD, col.getType()));
                continue;
            }
            TagFamilySpec.TagSpec tagSpec = this.parseTagSpec(col);
            if (tagSpec == null) continue;
            builder.spec(col.getColumnName().getStorageName(), new ColumnSpec(ColumnType.TAG, col.getType()));
            if (col.shouldIndex()) {
                IndexRule indexRule = this.parseIndexRule(tagSpec.getTagName(), col);
                tagMetadataList.add(new TagMetadata(indexRule, tagSpec));
                continue;
            }
            tagMetadataList.add(new TagMetadata(null, tagSpec));
        }
        return tagMetadataList;
    }

    @Nullable
    private TagFamilySpec.TagSpec parseTagSpec(ModelColumn modelColumn) {
        ParameterizedType t;
        Class clazz = modelColumn.getType();
        String colName = modelColumn.getColumnName().getStorageName();
        if (String.class.equals((Object)clazz) || StorageDataComplexObject.class.isAssignableFrom(clazz) || JsonObject.class.equals((Object)clazz)) {
            return TagFamilySpec.TagSpec.newStringTag((String)colName);
        }
        if (Integer.TYPE.equals(clazz) || Long.TYPE.equals(clazz)) {
            return TagFamilySpec.TagSpec.newIntTag((String)colName);
        }
        if (byte[].class.equals((Object)clazz)) {
            return TagFamilySpec.TagSpec.newBinaryTag((String)colName);
        }
        if (clazz.isEnum()) {
            return TagFamilySpec.TagSpec.newIntTag((String)colName);
        }
        if (Double.TYPE.equals(clazz) || Double.class.equals((Object)clazz)) {
            return TagFamilySpec.TagSpec.newBinaryTag((String)colName);
        }
        if (IntList.class.isAssignableFrom(clazz)) {
            return TagFamilySpec.TagSpec.newIntArrayTag((String)colName);
        }
        if (List.class.isAssignableFrom(clazz) && String.class.equals((Object)(t = (ParameterizedType)modelColumn.getGenericType()).getActualTypeArguments()[0])) {
            return TagFamilySpec.TagSpec.newStringArrayTag((String)colName);
        }
        throw new IllegalStateException("type " + modelColumn.getType().toString() + " is not supported");
    }

    public SchemaMetadata parseMetadata(Model model, BanyanDBStorageConfig config) {
        if (model.isRecord()) {
            String group = "stream-default";
            if (model.isSuperDataset()) {
                group = "stream-" + model.getName();
            }
            return new SchemaMetadata(group, model.getName(), Kind.STREAM, config.getRecordShardsNumber() * (model.isSuperDataset() ? config.getSuperDatasetShardsFactor() : 1));
        }
        return new SchemaMetadata("measure-default", model.getName(), Kind.MEASURE, config.getMetricsShardsNumber());
    }

    private /* synthetic */ void lambda$registerModel$1(Measure.Builder builder, Map modelColumnMap, ValueColumnMetadata.ValueColumn valueColumn) {
        builder.addField(this.parseFieldSpec((ModelColumn)modelColumnMap.get(valueColumn.getValueCName()), valueColumn));
    }

    static {
        log = LoggerFactory.getLogger(MetadataRegistry.class);
    }

    public static enum ColumnType {
        TAG,
        FIELD;

    }

    public static class ColumnSpec {
        private final ColumnType columnType;
        private final Class<?> columnClass;

        @Generated
        public ColumnSpec(ColumnType columnType, Class<?> columnClass) {
            this.columnType = columnType;
            this.columnClass = columnClass;
        }

        @Generated
        public ColumnType getColumnType() {
            return this.columnType;
        }

        @Generated
        public Class<?> getColumnClass() {
            return this.columnClass;
        }
    }

    public static class Schema {
        private final SchemaMetadata metadata;
        private final Map<String, ColumnSpec> specs;
        private final Set<String> tags;
        private final Set<String> fields;

        public ColumnSpec getSpec(String columnName) {
            return this.specs.get(columnName);
        }

        @Generated
        Schema(SchemaMetadata metadata, Map<String, ColumnSpec> specs, Set<String> tags, Set<String> fields) {
            this.metadata = metadata;
            this.specs = specs;
            this.tags = tags;
            this.fields = fields;
        }

        @Generated
        public static SchemaBuilder builder() {
            return new SchemaBuilder();
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Schema)) {
                return false;
            }
            Schema other = (Schema)o;
            if (!other.canEqual(this)) {
                return false;
            }
            SchemaMetadata this$metadata = this.getMetadata();
            SchemaMetadata other$metadata = other.getMetadata();
            if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
                return false;
            }
            Map<String, ColumnSpec> this$specs = this.specs;
            Map<String, ColumnSpec> other$specs = other.specs;
            if (this$specs == null ? other$specs != null : !((Object)this$specs).equals(other$specs)) {
                return false;
            }
            Set<String> this$tags = this.getTags();
            Set<String> other$tags = other.getTags();
            if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
                return false;
            }
            Set<String> this$fields = this.getFields();
            Set<String> other$fields = other.getFields();
            return !(this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Schema;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            SchemaMetadata $metadata = this.getMetadata();
            result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
            Map<String, ColumnSpec> $specs = this.specs;
            result = result * 59 + ($specs == null ? 43 : ((Object)$specs).hashCode());
            Set<String> $tags = this.getTags();
            result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
            Set<String> $fields = this.getFields();
            result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
            return result;
        }

        @Generated
        public SchemaMetadata getMetadata() {
            return this.metadata;
        }

        @Generated
        public Set<String> getTags() {
            return this.tags;
        }

        @Generated
        public Set<String> getFields() {
            return this.fields;
        }

        @Generated
        public static class SchemaBuilder {
            @Generated
            private SchemaMetadata metadata;
            @Generated
            private ArrayList<String> specs$key;
            @Generated
            private ArrayList<ColumnSpec> specs$value;
            @Generated
            private ArrayList<String> tags;
            @Generated
            private ArrayList<String> fields;

            @Generated
            SchemaBuilder() {
            }

            @Generated
            public SchemaBuilder metadata(SchemaMetadata metadata) {
                this.metadata = metadata;
                return this;
            }

            @Generated
            public SchemaBuilder spec(String specKey, ColumnSpec specValue) {
                if (this.specs$key == null) {
                    this.specs$key = new ArrayList();
                    this.specs$value = new ArrayList();
                }
                this.specs$key.add(specKey);
                this.specs$value.add(specValue);
                return this;
            }

            @Generated
            public SchemaBuilder specs(Map<? extends String, ? extends ColumnSpec> specs) {
                if (specs == null) {
                    throw new NullPointerException("specs cannot be null");
                }
                if (this.specs$key == null) {
                    this.specs$key = new ArrayList();
                    this.specs$value = new ArrayList();
                }
                for (Map.Entry<? extends String, ? extends ColumnSpec> $lombokEntry : specs.entrySet()) {
                    this.specs$key.add($lombokEntry.getKey());
                    this.specs$value.add($lombokEntry.getValue());
                }
                return this;
            }

            @Generated
            public SchemaBuilder clearSpecs() {
                if (this.specs$key != null) {
                    this.specs$key.clear();
                    this.specs$value.clear();
                }
                return this;
            }

            @Generated
            public SchemaBuilder tag(String tag) {
                if (this.tags == null) {
                    this.tags = new ArrayList();
                }
                this.tags.add(tag);
                return this;
            }

            @Generated
            public SchemaBuilder tags(Collection<? extends String> tags) {
                if (tags == null) {
                    throw new NullPointerException("tags cannot be null");
                }
                if (this.tags == null) {
                    this.tags = new ArrayList();
                }
                this.tags.addAll(tags);
                return this;
            }

            @Generated
            public SchemaBuilder clearTags() {
                if (this.tags != null) {
                    this.tags.clear();
                }
                return this;
            }

            @Generated
            public SchemaBuilder field(String field) {
                if (this.fields == null) {
                    this.fields = new ArrayList();
                }
                this.fields.add(field);
                return this;
            }

            @Generated
            public SchemaBuilder fields(Collection<? extends String> fields) {
                if (fields == null) {
                    throw new NullPointerException("fields cannot be null");
                }
                if (this.fields == null) {
                    this.fields = new ArrayList();
                }
                this.fields.addAll(fields);
                return this;
            }

            @Generated
            public SchemaBuilder clearFields() {
                if (this.fields != null) {
                    this.fields.clear();
                }
                return this;
            }

            @Generated
            public Schema build() {
                Set<String> fields;
                Set<Object> tags;
                Map<Object, Object> specs;
                switch (this.specs$key == null ? 0 : this.specs$key.size()) {
                    case 0: {
                        specs = Collections.emptyMap();
                        break;
                    }
                    case 1: {
                        specs = Collections.singletonMap(this.specs$key.get(0), this.specs$value.get(0));
                        break;
                    }
                    default: {
                        specs = new LinkedHashMap(this.specs$key.size() < 0x40000000 ? 1 + this.specs$key.size() + (this.specs$key.size() - 3) / 3 : Integer.MAX_VALUE);
                        for (int $i = 0; $i < this.specs$key.size(); ++$i) {
                            specs.put(this.specs$key.get($i), this.specs$value.get($i));
                        }
                        specs = Collections.unmodifiableMap(specs);
                    }
                }
                switch (this.tags == null ? 0 : this.tags.size()) {
                    case 0: {
                        tags = Collections.emptySet();
                        break;
                    }
                    case 1: {
                        tags = Collections.singleton(this.tags.get(0));
                        break;
                    }
                    default: {
                        tags = new LinkedHashSet(this.tags.size() < 0x40000000 ? 1 + this.tags.size() + (this.tags.size() - 3) / 3 : Integer.MAX_VALUE);
                        tags.addAll(this.tags);
                        tags = Collections.unmodifiableSet(tags);
                    }
                }
                switch (this.fields == null ? 0 : this.fields.size()) {
                    case 0: {
                        fields = Collections.emptySet();
                        break;
                    }
                    case 1: {
                        fields = Collections.singleton(this.fields.get(0));
                        break;
                    }
                    default: {
                        fields = new LinkedHashSet(this.fields.size() < 0x40000000 ? 1 + this.fields.size() + (this.fields.size() - 3) / 3 : Integer.MAX_VALUE);
                        fields.addAll(this.fields);
                        fields = Collections.unmodifiableSet(fields);
                    }
                }
                return new Schema(this.metadata, specs, tags, fields);
            }

            @Generated
            public String toString() {
                return "MetadataRegistry.Schema.SchemaBuilder(metadata=" + this.metadata + ", specs$key=" + this.specs$key + ", specs$value=" + this.specs$value + ", tags=" + this.tags + ", fields=" + this.fields + ")";
            }
        }
    }

    private static class TagMetadata {
        private final IndexRule indexRule;
        private final TagFamilySpec.TagSpec tagSpec;

        boolean isIndex() {
            return this.indexRule != null;
        }

        @Generated
        public TagMetadata(IndexRule indexRule, TagFamilySpec.TagSpec tagSpec) {
            this.indexRule = indexRule;
            this.tagSpec = tagSpec;
        }

        @Generated
        public IndexRule getIndexRule() {
            return this.indexRule;
        }

        @Generated
        public TagFamilySpec.TagSpec getTagSpec() {
            return this.tagSpec;
        }
    }

    public static enum Kind {
        MEASURE,
        STREAM;

    }

    public static class SchemaMetadata {
        private final String group;
        private final String name;
        private final Kind kind;
        private final int shard;

        public Optional<NamedSchema<?>> findRemoteSchema(BanyanDBClient client) throws BanyanDBException {
            try {
                switch (this.kind) {
                    case STREAM: {
                        return Optional.ofNullable(client.findStream(this.group, this.name));
                    }
                    case MEASURE: {
                        return Optional.ofNullable(client.findMeasure(this.group, this.name));
                    }
                }
                throw new IllegalStateException("should not reach here");
            }
            catch (BanyanDBException ex) {
                if (ex.getStatus().equals((Object)Status.Code.NOT_FOUND)) {
                    return Optional.empty();
                }
                throw ex;
            }
        }

        private List<TagFamilySpec> extractTagFamilySpec(List<TagMetadata> tagMetadataList) {
            Map<String, List<TagMetadata>> tagMetadataMap = tagMetadataList.stream().collect(Collectors.groupingBy(tagMetadata -> tagMetadata.isIndex() ? this.indexFamily() : this.nonIndexFamily()));
            ArrayList<TagFamilySpec> tagFamilySpecs = new ArrayList<TagFamilySpec>(tagMetadataMap.size());
            for (Map.Entry<String, List<TagMetadata>> entry : tagMetadataMap.entrySet()) {
                TagFamilySpec.Builder b = TagFamilySpec.create((String)entry.getKey()).addTagSpecs((Iterable)entry.getValue().stream().map(TagMetadata::getTagSpec).collect(Collectors.toList()));
                if (this.getKind() == Kind.MEASURE && entry.getKey().equals(this.indexFamily())) {
                    b.addIDTagSpec();
                }
                tagFamilySpecs.add(b.build());
            }
            return tagFamilySpecs;
        }

        public Group getOrCreateGroup(BanyanDBClient client) throws BanyanDBException {
            Group g = client.findGroup(this.group);
            if (g != null) {
                return g;
            }
            switch (this.kind) {
                case STREAM: {
                    return client.define(Group.create((String)this.group, (Catalog)Catalog.STREAM, (int)this.shard, (int)0, (Duration)Duration.ofDays((long)7L)));
                }
                case MEASURE: {
                    return client.define(Group.create((String)this.group, (Catalog)Catalog.MEASURE, (int)this.shard, (int)12, (Duration)Duration.ofDays((long)7L)));
                }
            }
            throw new IllegalStateException("should not reach here");
        }

        public String indexFamily() {
            switch (this.kind) {
                case MEASURE: {
                    return "default";
                }
                case STREAM: {
                    return "searchable";
                }
            }
            throw new IllegalStateException("should not reach here");
        }

        public String nonIndexFamily() {
            switch (this.kind) {
                case STREAM: 
                case MEASURE: {
                    return "storage-only";
                }
            }
            throw new IllegalStateException("should not reach here");
        }

        @Generated
        public SchemaMetadata(String group, String name, Kind kind, int shard) {
            this.group = group;
            this.name = name;
            this.kind = kind;
            this.shard = shard;
        }

        @Generated
        public String getGroup() {
            return this.group;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public Kind getKind() {
            return this.kind;
        }

        @Generated
        public int getShard() {
            return this.shard;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SchemaMetadata)) {
                return false;
            }
            SchemaMetadata other = (SchemaMetadata)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getShard() != other.getShard()) {
                return false;
            }
            String this$group = this.getGroup();
            String other$group = other.getGroup();
            if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Kind this$kind = this.getKind();
            Kind other$kind = other.getKind();
            return !(this$kind == null ? other$kind != null : !((Object)((Object)this$kind)).equals((Object)other$kind));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SchemaMetadata;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getShard();
            String $group = this.getGroup();
            result = result * 59 + ($group == null ? 43 : $group.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Kind $kind = this.getKind();
            result = result * 59 + ($kind == null ? 43 : ((Object)((Object)$kind)).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "MetadataRegistry.SchemaMetadata(group=" + this.getGroup() + ", name=" + this.getName() + ", kind=" + (Object)((Object)this.getKind()) + ", shard=" + this.getShard() + ")";
        }
    }
}

