/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.banyandb.v1.client.TagAndValue;
import org.apache.skywalking.banyandb.v1.client.metadata.Property;
import org.apache.skywalking.oap.server.core.management.ui.template.UITemplate;
import org.apache.skywalking.oap.server.core.query.input.DashboardSetting;
import org.apache.skywalking.oap.server.core.query.type.DashboardConfiguration;
import org.apache.skywalking.oap.server.core.query.type.TemplateChangeStatus;
import org.apache.skywalking.oap.server.core.storage.management.UITemplateManagementDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.AbstractBanyanDBDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BanyanDBUITemplateManagementDAO
extends AbstractBanyanDBDAO
implements UITemplateManagementDAO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BanyanDBUITemplateManagementDAO.class);
    private static final String GROUP = "sw";

    public BanyanDBUITemplateManagementDAO(BanyanDBStorageClient client) {
        super(client);
    }

    public DashboardConfiguration getTemplate(String id) throws IOException {
        Property p = ((BanyanDBStorageClient)this.getClient()).queryProperty(GROUP, "ui_template", id);
        if (p == null) {
            return null;
        }
        return this.fromEntity(this.parse(p));
    }

    public List<DashboardConfiguration> getAllTemplates(Boolean includingDisabled) throws IOException {
        List<Property> propertyList = ((BanyanDBStorageClient)this.getClient()).listProperties(GROUP, "ui_template");
        return propertyList.stream().map(p -> this.fromEntity(this.parse((Property)p))).filter(conf -> includingDisabled != false || !conf.isDisabled()).collect(Collectors.toList());
    }

    public TemplateChangeStatus addTemplate(DashboardSetting setting) {
        Property newTemplate = this.convert(setting.toEntity());
        try {
            ((BanyanDBStorageClient)this.getClient()).define(newTemplate);
            return TemplateChangeStatus.builder().status(true).id(newTemplate.id()).build();
        }
        catch (IOException ioEx) {
            log.error("fail to add new template", (Throwable)ioEx);
            return TemplateChangeStatus.builder().status(false).id(setting.getId()).message("Can't add a new template").build();
        }
    }

    public TemplateChangeStatus changeTemplate(DashboardSetting setting) {
        Property newTemplate = this.convert(setting.toEntity());
        try {
            ((BanyanDBStorageClient)this.getClient()).define(newTemplate);
            return TemplateChangeStatus.builder().status(true).id(newTemplate.id()).build();
        }
        catch (IOException ioEx) {
            log.error("fail to modify the template", (Throwable)ioEx);
            return TemplateChangeStatus.builder().status(false).id(setting.getId()).message("Can't change an existed template").build();
        }
    }

    public TemplateChangeStatus disableTemplate(String id) throws IOException {
        Property oldProperty = ((BanyanDBStorageClient)this.getClient()).queryProperty(GROUP, "ui_template", id);
        if (oldProperty == null) {
            return TemplateChangeStatus.builder().status(false).id(id).message("Can't find the template").build();
        }
        UITemplate uiTemplate = this.parse(oldProperty);
        uiTemplate.setDisabled(0);
        try {
            ((BanyanDBStorageClient)this.getClient()).define(this.convert(uiTemplate));
            return TemplateChangeStatus.builder().status(true).id(uiTemplate.id()).build();
        }
        catch (IOException ioEx) {
            log.error("fail to disable the template", (Throwable)ioEx);
            return TemplateChangeStatus.builder().status(false).id(uiTemplate.id()).message("Can't disable the template").build();
        }
    }

    public DashboardConfiguration fromEntity(UITemplate uiTemplate) {
        DashboardConfiguration conf = new DashboardConfiguration();
        conf.fromEntity(uiTemplate);
        return conf;
    }

    public UITemplate parse(Property property) {
        UITemplate uiTemplate = new UITemplate();
        uiTemplate.setTemplateId(property.id());
        for (TagAndValue tagAndValue : property.tags()) {
            if (tagAndValue.getTagName().equals("configuration")) {
                uiTemplate.setConfiguration((String)tagAndValue.getValue());
                continue;
            }
            if (tagAndValue.getTagName().equals("disabled")) {
                uiTemplate.setDisabled(((Number)tagAndValue.getValue()).intValue());
                continue;
            }
            if (!tagAndValue.getTagName().equals("update_time")) continue;
            uiTemplate.setUpdateTime(((Number)tagAndValue.getValue()).longValue());
        }
        return uiTemplate;
    }

    public Property convert(UITemplate uiTemplate) {
        return Property.create((String)GROUP, (String)"ui_template", (String)uiTemplate.id()).addTag(TagAndValue.newStringTag((String)"configuration", (String)uiTemplate.getConfiguration())).addTag(TagAndValue.newLongTag((String)"disabled", (long)uiTemplate.getDisabled())).addTag(TagAndValue.newLongTag((String)"update_time", (long)uiTemplate.getUpdateTime())).build();
    }
}

