/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.skywalking.banyandb.v1.client.DataPoint;
import org.apache.skywalking.banyandb.v1.client.MeasureQuery;
import org.apache.skywalking.banyandb.v1.client.MeasureQueryResponse;
import org.apache.skywalking.banyandb.v1.client.TimestampRange;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.query.enumeration.Order;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.input.TopNCondition;
import org.apache.skywalking.oap.server.core.query.type.SelectedRecord;
import org.apache.skywalking.oap.server.core.storage.query.ITopNRecordsQueryDAO;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.MetadataRegistry;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.AbstractBanyanDBDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.util.ByteUtil;

public class BanyanDBTopNRecordsQueryDAO
extends AbstractBanyanDBDAO
implements ITopNRecordsQueryDAO {
    private static final Set<String> TAGS = ImmutableSet.of((Object)"time_bucket", (Object)"service_id", (Object)"statement", (Object)"trace_id");

    public BanyanDBTopNRecordsQueryDAO(BanyanDBStorageClient client) {
        super(client);
    }

    public List<SelectedRecord> readSampledRecords(final TopNCondition condition, final String valueColumnName, final Duration duration) throws IOException {
        String modelName = condition.getName();
        TimestampRange timestampRange = new TimestampRange(duration.getStartTimestamp(), duration.getEndTimestamp());
        MeasureQueryResponse resp = this.query(modelName, TAGS, Collections.singleton(valueColumnName), timestampRange, new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
                if (StringUtil.isNotEmpty((String)condition.getParentService())) {
                    String serviceId = IDManager.ServiceID.buildId((String)condition.getParentService(), (boolean)condition.isNormal());
                    query.and(this.eq("service_id", serviceId));
                }
                if (condition.getOrder() == Order.DES) {
                    query.topN(condition.getTopN(), valueColumnName);
                } else {
                    query.bottomN(condition.getTopN(), valueColumnName);
                }
                query.and(this.gte("time_bucket", duration.getStartTimeBucketInSec()));
                query.and(this.lte("time_bucket", duration.getEndTimeBucketInSec()));
            }
        });
        if (resp.size() == 0) {
            return Collections.emptyList();
        }
        MetadataRegistry.Schema schema = MetadataRegistry.INSTANCE.findMetadata(modelName);
        if (schema == null) {
            throw new IOException("schema is not registered");
        }
        MetadataRegistry.ColumnSpec spec = schema.getSpec(valueColumnName);
        if (spec == null) {
            throw new IOException("field spec is not registered");
        }
        ArrayList<SelectedRecord> results = new ArrayList<SelectedRecord>(condition.getTopN());
        for (DataPoint dataPoint : resp.getDataPoints()) {
            SelectedRecord record = new SelectedRecord();
            record.setName((String)dataPoint.getTagValue("statement"));
            record.setRefId((String)dataPoint.getTagValue("trace_id"));
            record.setId((String)dataPoint.getTagValue("entity_id"));
            record.setValue(this.extractFieldValueAsString(spec, valueColumnName, dataPoint));
            results.add(record);
        }
        return results;
    }

    private String extractFieldValueAsString(MetadataRegistry.ColumnSpec spec, String fieldName, DataPoint dataPoint) throws IOException {
        if (Double.TYPE.equals(spec.getColumnClass())) {
            return String.valueOf(ByteUtil.bytes2Double((byte[])dataPoint.getFieldValue(fieldName)).longValue());
        }
        if (String.class.equals(spec.getColumnClass())) {
            return (String)dataPoint.getFieldValue(fieldName);
        }
        return String.valueOf(((Number)dataPoint.getFieldValue(fieldName)).longValue());
    }
}

