/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb;

import java.io.IOException;
import lombok.Generated;
import org.apache.skywalking.banyandb.v1.client.StreamWrite;
import org.apache.skywalking.oap.server.core.analysis.DownSampling;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.analysis.config.NoneStream;
import org.apache.skywalking.oap.server.core.storage.AbstractDAO;
import org.apache.skywalking.oap.server.core.storage.INoneStreamDAO;
import org.apache.skywalking.oap.server.core.storage.StorageData;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;
import org.apache.skywalking.oap.server.library.client.Client;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBConverter;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.MetadataRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BanyanDBNoneStreamDAO
extends AbstractDAO<BanyanDBStorageClient>
implements INoneStreamDAO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BanyanDBNoneStreamDAO.class);
    private final StorageBuilder<NoneStream> storageBuilder;

    public BanyanDBNoneStreamDAO(BanyanDBStorageClient client, StorageBuilder<NoneStream> storageBuilder) {
        super((Client)client);
        this.storageBuilder = storageBuilder;
    }

    public void insert(Model model, NoneStream noneStream) throws IOException {
        MetadataRegistry.Schema schema = MetadataRegistry.INSTANCE.findMetadata(model.getName());
        if (schema == null) {
            throw new IOException(model.getName() + " is not registered");
        }
        StreamWrite streamWrite = new StreamWrite(schema.getMetadata().getGroup(), model.getName(), noneStream.id(), TimeBucket.getTimestamp((long)noneStream.getTimeBucket(), (DownSampling)model.getDownsampling()));
        BanyanDBConverter.StreamToStorage convert2Storage = new BanyanDBConverter.StreamToStorage(schema, streamWrite);
        this.storageBuilder.entity2Storage((StorageData)noneStream, (Convert2Storage)convert2Storage);
        ((BanyanDBStorageClient)this.getClient()).write(streamWrite);
    }
}

