/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb;

import java.io.IOException;
import lombok.Generated;
import org.apache.skywalking.banyandb.v1.client.BanyanDBClient;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.BanyanDBException;
import org.apache.skywalking.banyandb.v1.client.metadata.Group;
import org.apache.skywalking.banyandb.v1.client.metadata.Measure;
import org.apache.skywalking.banyandb.v1.client.metadata.Stream;
import org.apache.skywalking.oap.server.core.storage.StorageException;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.storage.model.ModelInstaller;
import org.apache.skywalking.oap.server.library.client.Client;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageConfig;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.MetadataRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BanyanDBIndexInstaller
extends ModelInstaller {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BanyanDBIndexInstaller.class);
    private final BanyanDBStorageConfig config;

    public BanyanDBIndexInstaller(Client client, ModuleManager moduleManager, BanyanDBStorageConfig config) {
        super(client, moduleManager);
        this.config = config;
    }

    protected boolean isExists(Model model) throws StorageException {
        MetadataRegistry.SchemaMetadata metadata = MetadataRegistry.INSTANCE.parseMetadata(model, this.config);
        try {
            BanyanDBClient c = ((BanyanDBStorageClient)this.client).client;
            Group g = metadata.getOrCreateGroup(c);
            if (g == null) {
                throw new StorageException("fail to create group " + metadata.getGroup());
            }
            log.info("group {} created", (Object)g.name());
            if (metadata.findRemoteSchema(c).isPresent()) {
                MetadataRegistry.INSTANCE.registerModel(model, this.config);
                return true;
            }
            return false;
        }
        catch (BanyanDBException ex) {
            throw new StorageException("fail to check existence", (Throwable)ex);
        }
    }

    protected void createTable(Model model) throws StorageException {
        try {
            if (model.isTimeSeries() && model.isRecord()) {
                Stream stream = (Stream)MetadataRegistry.INSTANCE.registerModel(model, this.config);
                if (stream != null) {
                    log.info("install stream schema {}", (Object)model.getName());
                    ((BanyanDBStorageClient)this.client).define(stream);
                }
            } else if (model.isTimeSeries() && !model.isRecord()) {
                Measure measure = (Measure)MetadataRegistry.INSTANCE.registerModel(model, this.config);
                if (measure != null) {
                    log.info("install measure schema {}", (Object)model.getName());
                    ((BanyanDBStorageClient)this.client).define(measure);
                }
            } else if (!model.isTimeSeries()) {
                log.info("skip property index {}", (Object)model.getName());
            }
        }
        catch (IOException ex) {
            throw new StorageException("fail to install schema", (Throwable)ex);
        }
    }
}

