/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.skywalking.banyandb.v1.client.AbstractWrite;
import org.apache.skywalking.banyandb.v1.client.MeasureBulkWriteProcessor;
import org.apache.skywalking.banyandb.v1.client.StreamBulkWriteProcessor;
import org.apache.skywalking.oap.server.core.storage.AbstractDAO;
import org.apache.skywalking.oap.server.core.storage.IBatchDAO;
import org.apache.skywalking.oap.server.library.client.Client;
import org.apache.skywalking.oap.server.library.client.request.InsertRequest;
import org.apache.skywalking.oap.server.library.client.request.PrepareRequest;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.measure.BanyanDBMeasureInsertRequest;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.measure.BanyanDBMeasureUpdateRequest;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.BanyanDBStreamInsertRequest;

public class BanyanDBBatchDAO
extends AbstractDAO<BanyanDBStorageClient>
implements IBatchDAO {
    private static final Object STREAM_SYNCHRONIZER = new Object();
    private static final Object MEASURE_SYNCHRONIZER = new Object();
    private StreamBulkWriteProcessor streamBulkWriteProcessor;
    private MeasureBulkWriteProcessor measureBulkWriteProcessor;
    private final int maxBulkSize;
    private final int flushInterval;
    private final int concurrency;

    public BanyanDBBatchDAO(BanyanDBStorageClient client, int maxBulkSize, int flushInterval, int concurrency) {
        super((Client)client);
        this.maxBulkSize = maxBulkSize;
        this.flushInterval = flushInterval;
        this.concurrency = concurrency;
    }

    public void insert(InsertRequest insertRequest) {
        if (insertRequest instanceof BanyanDBStreamInsertRequest) {
            this.getStreamBulkWriteProcessor().add((AbstractWrite)((BanyanDBStreamInsertRequest)insertRequest).getStreamWrite());
        } else if (insertRequest instanceof BanyanDBMeasureInsertRequest) {
            this.getMeasureBulkWriteProcessor().add((AbstractWrite)((BanyanDBMeasureInsertRequest)insertRequest).getMeasureWrite());
        }
    }

    public CompletableFuture<Void> flush(List<PrepareRequest> prepareRequests) {
        if (CollectionUtils.isNotEmpty(prepareRequests)) {
            for (PrepareRequest r : prepareRequests) {
                if (r instanceof BanyanDBStreamInsertRequest) {
                    this.getStreamBulkWriteProcessor().add((AbstractWrite)((BanyanDBStreamInsertRequest)r).getStreamWrite());
                    continue;
                }
                if (r instanceof BanyanDBMeasureInsertRequest) {
                    this.getMeasureBulkWriteProcessor().add((AbstractWrite)((BanyanDBMeasureInsertRequest)r).getMeasureWrite());
                    continue;
                }
                if (!(r instanceof BanyanDBMeasureUpdateRequest)) continue;
                this.getMeasureBulkWriteProcessor().add((AbstractWrite)((BanyanDBMeasureUpdateRequest)r).getMeasureWrite());
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StreamBulkWriteProcessor getStreamBulkWriteProcessor() {
        if (this.streamBulkWriteProcessor == null) {
            Object object = STREAM_SYNCHRONIZER;
            synchronized (object) {
                if (this.streamBulkWriteProcessor == null) {
                    this.streamBulkWriteProcessor = ((BanyanDBStorageClient)this.getClient()).createStreamBulkProcessor(this.maxBulkSize, this.flushInterval, this.concurrency);
                }
            }
        }
        return this.streamBulkWriteProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MeasureBulkWriteProcessor getMeasureBulkWriteProcessor() {
        if (this.measureBulkWriteProcessor == null) {
            Object object = MEASURE_SYNCHRONIZER;
            synchronized (object) {
                if (this.measureBulkWriteProcessor == null) {
                    this.measureBulkWriteProcessor = ((BanyanDBStorageClient)this.getClient()).createMeasureBulkProcessor(this.maxBulkSize, this.flushInterval, this.concurrency);
                }
            }
        }
        return this.measureBulkWriteProcessor;
    }
}

