/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.util.prometheus.metrics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oap.server.library.util.prometheus.metrics.Counter;
import org.apache.skywalking.oap.server.library.util.prometheus.metrics.Gauge;
import org.apache.skywalking.oap.server.library.util.prometheus.metrics.Histogram;
import org.apache.skywalking.oap.server.library.util.prometheus.metrics.Metric;
import org.apache.skywalking.oap.server.library.util.prometheus.metrics.MetricType;
import org.apache.skywalking.oap.server.library.util.prometheus.metrics.Summary;

public class MetricFamily {
    private final String name;
    private final String help;
    private final MetricType type;
    private final List<Metric> metrics;

    protected MetricFamily(Builder builder) {
        Class expectedMetricClassType;
        if (builder.name == null) {
            throw new IllegalArgumentException("Need to set name");
        }
        if (builder.type == null) {
            throw new IllegalArgumentException("Need to set type");
        }
        switch (builder.type) {
            case COUNTER: {
                expectedMetricClassType = Counter.class;
                break;
            }
            case GAUGE: {
                expectedMetricClassType = Gauge.class;
                break;
            }
            case SUMMARY: {
                expectedMetricClassType = Summary.class;
                break;
            }
            case HISTOGRAM: {
                expectedMetricClassType = Histogram.class;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid type: " + (Object)((Object)builder.type));
            }
        }
        if (builder.metrics != null && !builder.metrics.isEmpty()) {
            for (Metric metric : builder.metrics) {
                if (expectedMetricClassType.isInstance(metric)) continue;
                throw new IllegalArgumentException(String.format("Metric type is [%s] so instances of class [%s] are expected, but got metric object of type [%s]", new Object[]{builder.type, expectedMetricClassType.getName(), metric.getClass().getName()}));
            }
        }
        this.name = builder.name;
        this.help = builder.help;
        this.type = builder.type;
        this.metrics = builder.metrics;
    }

    public String getName() {
        return this.name;
    }

    public String getHelp() {
        return this.help;
    }

    public MetricType getType() {
        return this.type;
    }

    public List<Metric> getMetrics() {
        if (this.metrics == null) {
            return Collections.emptyList();
        }
        return this.metrics;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetricFamily)) {
            return false;
        }
        MetricFamily other = (MetricFamily)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$help = this.getHelp();
        String other$help = other.getHelp();
        if (this$help == null ? other$help != null : !this$help.equals(other$help)) {
            return false;
        }
        MetricType this$type = this.getType();
        MetricType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        List<Metric> this$metrics = this.getMetrics();
        List<Metric> other$metrics = other.getMetrics();
        return !(this$metrics == null ? other$metrics != null : !((Object)this$metrics).equals(other$metrics));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MetricFamily;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $help = this.getHelp();
        result = result * 59 + ($help == null ? 43 : $help.hashCode());
        MetricType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        List<Metric> $metrics = this.getMetrics();
        result = result * 59 + ($metrics == null ? 43 : ((Object)$metrics).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MetricFamily(name=" + this.getName() + ", help=" + this.getHelp() + ", type=" + (Object)((Object)this.getType()) + ", metrics=" + this.getMetrics() + ")";
    }

    public static class Builder {
        private String name;
        private String help;
        private MetricType type;
        private List<Metric> metrics;

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setHelp(String help) {
            this.help = help;
            return this;
        }

        public Builder setType(MetricType type) {
            this.type = type;
            return this;
        }

        public Builder addMetric(Metric metric) {
            if (this.metrics == null) {
                this.metrics = new ArrayList<Metric>();
            }
            this.metrics.add(metric);
            return this;
        }

        public MetricFamily build() {
            return new MetricFamily(this);
        }
    }
}

