/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.util;

import java.util.function.Consumer;

public final class StringUtil {
    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtil.isEmpty(str);
    }

    public static boolean isBlank(String str) {
        return str == null || StringUtil.isEmpty(str.trim());
    }

    public static boolean isNotBlank(String str) {
        return !StringUtil.isBlank(str);
    }

    public static void setIfPresent(String value, Consumer<String> setter) {
        if (StringUtil.isNotEmpty(value)) {
            setter.accept(value);
        }
    }

    public static String join(char delimiter, String ... strings) {
        if (strings.length == 0) {
            return null;
        }
        if (strings.length == 1) {
            return strings[0];
        }
        int length = strings.length - 1;
        for (String s : strings) {
            if (s == null) continue;
            length += s.length();
        }
        StringBuilder sb = new StringBuilder(length);
        if (strings[0] != null) {
            sb.append(strings[0]);
        }
        for (int i = 1; i < strings.length; ++i) {
            if (!StringUtil.isEmpty(strings[i])) {
                sb.append(delimiter).append(strings[i]);
                continue;
            }
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static boolean substringMatch(CharSequence str, int index, CharSequence substring) {
        if (index + substring.length() > str.length()) {
            return false;
        }
        for (int i = 0; i < substring.length(); ++i) {
            if (str.charAt(index + i) == substring.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static String cut(String str, int threshold) {
        if (StringUtil.isEmpty(str) || str.length() <= threshold) {
            return str;
        }
        return str.substring(0, threshold);
    }

    public static String trim(String str, char ch) {
        int i;
        if (StringUtil.isEmpty(str)) {
            return null;
        }
        char[] chars = str.toCharArray();
        int j = chars.length - 1;
        for (i = 0; i < chars.length && chars[i] == ch; ++i) {
        }
        while (j > 0 && chars[j] == ch) {
            --j;
        }
        return new String(chars, i, j - i + 1);
    }
}

