/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import lombok.Generated;

public class StringFormatGroup {
    private final List<PatternRule> rules = new ArrayList<PatternRule>();

    public void addRule(String name, String ruleRegex) {
        for (PatternRule rule : this.rules) {
            if (!rule.name.equals(name)) continue;
            return;
        }
        PatternRule rule = new PatternRule(name, ruleRegex);
        this.rules.add(rule);
    }

    public FormatResult format(String string) {
        for (PatternRule rule : this.rules) {
            if (!rule.getPattern().matcher(string).matches()) continue;
            return new FormatResult(true, rule.getName(), string);
        }
        return new FormatResult(false, string, string);
    }

    public void sortRules(Comparator<? super PatternRule> comparator) {
        this.rules.sort(comparator);
    }

    @Generated
    public String toString() {
        return "StringFormatGroup(rules=" + this.rules + ")";
    }

    public static class PatternRule {
        private final String name;
        private final Pattern pattern;

        private PatternRule(String name, String ruleRegex) {
            this.name = name;
            this.pattern = Pattern.compile(ruleRegex);
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public Pattern getPattern() {
            return this.pattern;
        }

        @Generated
        public String toString() {
            return "StringFormatGroup.PatternRule(name=" + this.getName() + ", pattern=" + this.getPattern() + ")";
        }
    }

    public static class FormatResult {
        private final boolean match;
        private final String name;
        private final String replacedName;

        @Generated
        public boolean isMatch() {
            return this.match;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getReplacedName() {
            return this.replacedName;
        }

        @Generated
        public FormatResult(boolean match, String name, String replacedName) {
            this.match = match;
            this.name = name;
            this.replacedName = replacedName;
        }
    }
}

