/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class ResourceUtils {
    public static Reader read(String fileName) throws FileNotFoundException {
        return new InputStreamReader(ResourceUtils.readToStream(fileName), StandardCharsets.UTF_8);
    }

    public static InputStream readToStream(String fileName) throws FileNotFoundException {
        URL url = ResourceUtils.class.getClassLoader().getResource(fileName);
        if (url == null) {
            throw new FileNotFoundException("file not found: " + fileName);
        }
        return ResourceUtils.class.getClassLoader().getResourceAsStream(fileName);
    }

    public static File[] getPathFiles(String path) throws FileNotFoundException {
        URL url = ResourceUtils.class.getClassLoader().getResource(path);
        if (url == null) {
            throw new FileNotFoundException("path not found: " + path);
        }
        return (File[])Arrays.stream((Object[])Objects.requireNonNull(new File(url.getPath()).listFiles(), "No files in " + path)).filter(File::isFile).toArray(File[]::new);
    }

    public static List<File> getDirectoryFilesRecursive(String directoryPath, int maxDepth) throws FileNotFoundException {
        URL url = ResourceUtils.class.getClassLoader().getResource(directoryPath);
        if (url == null) {
            throw new FileNotFoundException("path not found: " + directoryPath);
        }
        ArrayList<File> fileList = new ArrayList<File>();
        return ResourceUtils.getDirectoryFilesRecursive(url.getPath(), fileList, maxDepth);
    }

    private static List<File> getDirectoryFilesRecursive(String directoryPath, List<File> fileList, int maxDepth) {
        File[] subFiles;
        if (maxDepth < 0) {
            return fileList;
        }
        --maxDepth;
        File file = new File(directoryPath);
        if (file.isDirectory() && (subFiles = file.listFiles()) != null) {
            for (File subFile : subFiles) {
                if (subFile.isDirectory()) {
                    ResourceUtils.getDirectoryFilesRecursive(subFile.getPath(), fileList, maxDepth);
                    continue;
                }
                fileList.add(subFile);
            }
        }
        return fileList;
    }
}

