/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.server.http;

import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.Route;
import com.linecorp.armeria.server.ServerBuilder;
import com.linecorp.armeria.server.docs.DocService;
import com.linecorp.armeria.server.logging.LoggingService;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.skywalking.oap.server.library.server.Server;
import org.apache.skywalking.oap.server.library.server.http.HTTPServerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPServer
implements Server {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HTTPServer.class);
    private final HTTPServerConfig config;
    private ServerBuilder sb;
    private final Set<HttpMethod> allowedMethods = new HashSet<HttpMethod>();

    public HTTPServer(HTTPServerConfig config) {
        this.config = config;
    }

    @Override
    public void initialize() {
        String contextPath = StringUtils.stripEnd((String)this.config.getContextPath(), (String)"/");
        this.sb = com.linecorp.armeria.server.Server.builder().serviceUnder(contextPath + "/docs", (HttpService)DocService.builder().build()).workerGroup(this.config.getMaxThreads()).http(new InetSocketAddress(this.config.getHost(), this.config.getPort())).http1MaxHeaderSize(this.config.getMaxRequestHeaderSize()).idleTimeout(Duration.ofMillis(this.config.getIdleTimeOut())).decorator(Route.ofCatchAll(), (delegate, ctx, req) -> {
            if (!this.allowedMethods.contains(ctx.method())) {
                return HttpResponse.of((HttpStatus)HttpStatus.METHOD_NOT_ALLOWED);
            }
            return delegate.serve(ctx, req);
        }).decorator(LoggingService.newDecorator());
        if (this.config.getAcceptQueueSize() > 0) {
            this.sb.maxNumConnections(this.config.getAcceptQueueSize());
        }
        log.info("Server root context path: {}", (Object)contextPath);
    }

    public void addHandler(Object handler, List<HttpMethod> httpMethods) {
        Objects.requireNonNull(this.allowedMethods, "allowedMethods");
        log.info("Bind handler {} into http server {}:{}", new Object[]{handler.getClass().getSimpleName(), this.config.getHost(), this.config.getPort()});
        this.sb.annotatedService().pathPrefix(this.config.getContextPath()).build(handler);
        this.allowedMethods.addAll(httpMethods);
    }

    @Override
    public void start() {
        this.sb.build().start().join();
    }
}

