/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.server.grpc;

import com.google.common.base.Strings;
import io.grpc.BindableService;
import io.grpc.ServerInterceptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.netty.NettyServerBuilder;
import io.netty.handler.ssl.SslContext;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.skywalking.oap.server.library.server.Server;
import org.apache.skywalking.oap.server.library.server.ServerException;
import org.apache.skywalking.oap.server.library.server.grpc.GRPCServerException;
import org.apache.skywalking.oap.server.library.server.grpc.ssl.DynamicSslContext;
import org.apache.skywalking.oap.server.library.server.pool.CustomThreadFactory;
import org.apache.skywalking.oap.server.library.server.ssl.AbstractSslContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GRPCServer
implements Server {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GRPCServer.class);
    private final String host;
    private final int port;
    private int maxConcurrentCallsPerConnection;
    private int maxMessageSize;
    private io.grpc.Server server;
    private NettyServerBuilder nettyServerBuilder;
    private String certChainFile;
    private String privateKeyFile;
    private String trustedCAsFile;
    private DynamicSslContext sslContext;
    private int threadPoolSize = Runtime.getRuntime().availableProcessors() * 4;
    private int threadPoolQueueSize = 10000;

    public GRPCServer(String host, int port) {
        this.host = host;
        this.port = port;
        this.maxConcurrentCallsPerConnection = 4;
        this.maxMessageSize = Integer.MAX_VALUE;
    }

    public void setMaxConcurrentCallsPerConnection(int maxConcurrentCallsPerConnection) {
        this.maxConcurrentCallsPerConnection = maxConcurrentCallsPerConnection;
    }

    public void setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    public void setThreadPoolQueueSize(int threadPoolQueueSize) {
        this.threadPoolQueueSize = threadPoolQueueSize;
    }

    public GRPCServer(String host, int port, String certChainFile, String privateKeyFile, String trustedCAsFile) {
        this(host, port);
        this.certChainFile = certChainFile;
        this.privateKeyFile = privateKeyFile;
        this.trustedCAsFile = trustedCAsFile;
    }

    @Override
    public void initialize() {
        InetSocketAddress address = new InetSocketAddress(this.host, this.port);
        ArrayBlockingQueue<Runnable> blockingQueue = new ArrayBlockingQueue<Runnable>(this.threadPoolQueueSize);
        ThreadPoolExecutor executor = new ThreadPoolExecutor(this.threadPoolSize, this.threadPoolSize, 60L, TimeUnit.SECONDS, blockingQueue, new CustomThreadFactory("grpcServerPool"), new CustomRejectedExecutionHandler());
        this.nettyServerBuilder = NettyServerBuilder.forAddress((SocketAddress)address);
        this.nettyServerBuilder = (NettyServerBuilder)this.nettyServerBuilder.maxConcurrentCallsPerConnection(this.maxConcurrentCallsPerConnection).maxInboundMessageSize(this.maxMessageSize).executor((Executor)executor);
        if (!Strings.isNullOrEmpty((String)this.privateKeyFile) && !Strings.isNullOrEmpty((String)this.certChainFile)) {
            this.sslContext = DynamicSslContext.forServer(this.privateKeyFile, this.certChainFile, this.trustedCAsFile);
            this.nettyServerBuilder.sslContext((SslContext)this.sslContext);
        }
        log.info("Server started, host {} listening on {}", (Object)this.host, (Object)this.port);
    }

    @Override
    public void start() throws ServerException {
        try {
            Optional.ofNullable(this.sslContext).ifPresent(AbstractSslContext::start);
            this.server = this.nettyServerBuilder.build();
            this.server.start();
        }
        catch (IOException e) {
            throw new GRPCServerException(e.getMessage(), e);
        }
    }

    public void addHandler(BindableService handler) {
        log.info("Bind handler {} into gRPC server {}:{}", new Object[]{handler.getClass().getSimpleName(), this.host, this.port});
        this.nettyServerBuilder.addService(handler);
    }

    public void addHandler(ServerServiceDefinition definition) {
        log.info("Bind handler {} into gRPC server {}:{}", new Object[]{definition.getClass().getSimpleName(), this.host, this.port});
        this.nettyServerBuilder.addService(definition);
    }

    public void addHandler(ServerInterceptor serverInterceptor) {
        log.info("Bind interceptor {} into gRPC server {}:{}", new Object[]{serverInterceptor.getClass().getSimpleName(), this.host, this.port});
        this.nettyServerBuilder.intercept(serverInterceptor);
    }

    static class CustomRejectedExecutionHandler
    implements RejectedExecutionHandler {
        CustomRejectedExecutionHandler() {
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            log.warn("Grpc server thread pool is full, rejecting the task");
        }
    }
}

