/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.recevier.log.provider.handler.rest;

import com.linecorp.armeria.server.annotation.Post;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.apm.network.common.v3.Commands;
import org.apache.skywalking.apm.network.logging.v3.LogData;
import org.apache.skywalking.oap.log.analyzer.provider.log.ILogAnalyzerService;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.telemetry.api.CounterMetrics;
import org.apache.skywalking.oap.server.telemetry.api.HistogramMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogReportServiceHTTPHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogReportServiceHTTPHandler.class);
    private final HistogramMetrics histogram;
    private final CounterMetrics errorCounter;
    private final ILogAnalyzerService logAnalyzerService;

    public LogReportServiceHTTPHandler(ModuleManager moduleManager) {
        MetricsCreator metricsCreator = (MetricsCreator)moduleManager.find("telemetry").provider().getService(MetricsCreator.class);
        this.logAnalyzerService = (ILogAnalyzerService)moduleManager.find("log-analyzer").provider().getService(ILogAnalyzerService.class);
        this.histogram = metricsCreator.createHistogramMetric("log_in_latency", "The process latency of log", new MetricsTag.Keys(new String[]{"protocol"}), new MetricsTag.Values(new String[]{"http"}), new double[0]);
        this.errorCounter = metricsCreator.createCounter("log_analysis_error_count", "The error number of log analysis", new MetricsTag.Keys(new String[]{"protocol"}), new MetricsTag.Values(new String[]{"http"}));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Post(value="/v3/logs")
    public Commands collectLogs(List<LogData> logs) {
        try (HistogramMetrics.Timer ignored = this.histogram.createTimer();){
            logs.forEach(it -> this.logAnalyzerService.doAnalysis(it, null));
            Commands commands = Commands.newBuilder().build();
            return commands;
        }
        catch (Throwable e) {
            this.errorCounter.inc();
            throw e;
        }
    }
}

