/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.rules;

import graphql.Internal;
import graphql.language.OperationDefinition;
import graphql.language.VariableDefinition;
import graphql.validation.AbstractRule;
import graphql.validation.ValidationContext;
import graphql.validation.ValidationErrorCollector;
import graphql.validation.ValidationErrorType;
import java.util.LinkedHashSet;
import java.util.List;

@Internal
public class UniqueVariableNamesRule
extends AbstractRule {
    public UniqueVariableNamesRule(ValidationContext validationContext, ValidationErrorCollector validationErrorCollector) {
        super(validationContext, validationErrorCollector);
    }

    @Override
    public void checkOperationDefinition(OperationDefinition operationDefinition) {
        List<VariableDefinition> variableDefinitions = operationDefinition.getVariableDefinitions();
        if (variableDefinitions == null || variableDefinitions.size() <= 1) {
            return;
        }
        LinkedHashSet<String> variableNameList = new LinkedHashSet<String>(variableDefinitions.size());
        for (VariableDefinition variableDefinition : variableDefinitions) {
            if (variableNameList.contains(variableDefinition.getName())) {
                this.addError(ValidationErrorType.DuplicateVariableName, variableDefinition.getSourceLocation(), UniqueVariableNamesRule.duplicateVariableNameMessage(variableDefinition.getName()));
                continue;
            }
            variableNameList.add(variableDefinition.getName());
        }
    }

    static String duplicateVariableNameMessage(String variableName) {
        return String.format("There can be only one variable named '%s'", variableName);
    }
}

