/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.zipkin.handler;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.gson.Gson;
import com.linecorp.armeria.common.AggregatedHttpResponse;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.ResponseHeadersBuilder;
import com.linecorp.armeria.server.annotation.Blocking;
import com.linecorp.armeria.server.annotation.Default;
import com.linecorp.armeria.server.annotation.ExceptionHandler;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Param;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.skywalking.oap.query.zipkin.ZipkinQueryConfig;
import org.apache.skywalking.oap.query.zipkin.handler.ZipkinQueryExceptionHandler;
import org.apache.skywalking.oap.server.core.analysis.DownSampling;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.analysis.manual.searchtag.TagType;
import org.apache.skywalking.oap.server.core.query.TagAutoCompleteQueryService;
import org.apache.skywalking.oap.server.core.storage.query.IZipkinQueryDAO;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import zipkin2.Span;
import zipkin2.codec.SpanBytesEncoder;
import zipkin2.storage.QueryRequest;

@ExceptionHandler(value=ZipkinQueryExceptionHandler.class)
public class ZipkinQueryHandler {
    private final ZipkinQueryConfig config;
    private final ModuleManager moduleManager;
    private IZipkinQueryDAO zipkinQueryDAO;
    private TagAutoCompleteQueryService tagQueryService;
    private final long defaultLookback;
    private final int namesMaxAge;
    private static final Gson GSON = new Gson();
    volatile int serviceCount;

    public ZipkinQueryHandler(ZipkinQueryConfig config, ModuleManager moduleManager) {
        this.config = config;
        this.moduleManager = moduleManager;
        this.defaultLookback = config.getLookback();
        this.namesMaxAge = config.getNamesMaxAge();
    }

    private IZipkinQueryDAO getZipkinQueryDAO() {
        if (this.zipkinQueryDAO == null) {
            this.zipkinQueryDAO = (IZipkinQueryDAO)this.moduleManager.find("storage").provider().getService(IZipkinQueryDAO.class);
        }
        return this.zipkinQueryDAO;
    }

    private TagAutoCompleteQueryService getTagQueryService() {
        if (this.tagQueryService == null) {
            this.tagQueryService = (TagAutoCompleteQueryService)this.moduleManager.find("core").provider().getService(TagAutoCompleteQueryService.class);
        }
        return this.tagQueryService;
    }

    @Get(value="/config.json")
    @Blocking
    public AggregatedHttpResponse getUIConfig() throws IOException {
        StringWriter writer = new StringWriter();
        JsonGenerator generator = new JsonFactory().createGenerator((Writer)writer);
        generator.writeStartObject();
        generator.writeStringField("environment", this.config.getUiEnvironment());
        generator.writeNumberField("queryLimit", this.config.getUiQueryLimit());
        generator.writeNumberField("defaultLookback", this.config.getUiDefaultLookback());
        generator.writeBooleanField("searchEnabled", this.config.isUiSearchEnabled());
        generator.writeObjectFieldStart("dependency");
        generator.writeBooleanField("enabled", false);
        generator.writeEndObject();
        generator.writeEndObject();
        generator.close();
        return AggregatedHttpResponse.of((HttpStatus)HttpStatus.OK, (MediaType)MediaType.JSON, (HttpData)HttpData.ofUtf8((String)writer.toString()));
    }

    @Get(value="/api/v2/services")
    @Blocking
    public AggregatedHttpResponse getServiceNames() throws IOException {
        List serviceNames = this.getZipkinQueryDAO().getServiceNames();
        this.serviceCount = serviceNames.size();
        return this.cachedResponse(this.serviceCount > 3, serviceNames);
    }

    @Get(value="/api/v2/remoteServices")
    @Blocking
    public AggregatedHttpResponse getRemoteServiceNames(@Param(value="serviceName") String serviceName) throws IOException {
        List remoteServiceNames = this.getZipkinQueryDAO().getRemoteServiceNames(serviceName);
        return this.cachedResponse(this.serviceCount > 3, remoteServiceNames);
    }

    @Get(value="/api/v2/spans")
    @Blocking
    public AggregatedHttpResponse getSpanNames(@Param(value="serviceName") String serviceName) throws IOException {
        List spanNames = this.getZipkinQueryDAO().getSpanNames(serviceName);
        return this.cachedResponse(this.serviceCount > 3, spanNames);
    }

    @Get(value="/api/v2/trace/{traceId}")
    @Blocking
    public AggregatedHttpResponse getTraceById(@Param(value="traceId") String traceId) throws IOException {
        if (StringUtil.isEmpty((String)traceId)) {
            return AggregatedHttpResponse.of((HttpStatus)HttpStatus.BAD_REQUEST, (MediaType)MediaType.ANY_TEXT_TYPE, (String)"traceId is empty or null");
        }
        List trace = this.getZipkinQueryDAO().getTrace(Span.normalizeTraceId((String)traceId.trim()));
        if (CollectionUtils.isEmpty((List)trace)) {
            return AggregatedHttpResponse.of((HttpStatus)HttpStatus.NOT_FOUND, (MediaType)MediaType.ANY_TEXT_TYPE, (String)(traceId + " not found"));
        }
        return this.response(SpanBytesEncoder.JSON_V2.encodeList(trace));
    }

    @Get(value="/api/v2/traces")
    @Blocking
    public AggregatedHttpResponse getTraces(@Param(value="serviceName") Optional<String> serviceName, @Param(value="remoteServiceName") Optional<String> remoteServiceName, @Param(value="spanName") Optional<String> spanName, @Param(value="annotationQuery") Optional<String> annotationQuery, @Param(value="minDuration") Optional<Long> minDuration, @Param(value="maxDuration") Optional<Long> maxDuration, @Param(value="endTs") Optional<Long> endTs, @Param(value="lookback") Optional<Long> lookback, @Default(value="10") @Param(value="limit") int limit) throws IOException {
        QueryRequest queryRequest = QueryRequest.newBuilder().serviceName((String)serviceName.orElse(null)).remoteServiceName((String)remoteServiceName.orElse(null)).spanName((String)spanName.orElse(null)).parseAnnotationQuery((String)annotationQuery.orElse(null)).minDuration((Long)minDuration.orElse(null)).maxDuration((Long)maxDuration.orElse(null)).endTs(endTs.orElse(System.currentTimeMillis()).longValue()).lookback(lookback.orElse(this.defaultLookback).longValue()).limit(limit).build();
        List traces = this.getZipkinQueryDAO().getTraces(queryRequest);
        return this.response(this.encodeTraces(traces));
    }

    @Get(value="/api/v2/traceMany")
    @Blocking
    public AggregatedHttpResponse getTracesByIds(@Param(value="traceIds") String traceIds) throws IOException {
        String[] traceIdsArr;
        if (StringUtil.isEmpty((String)traceIds)) {
            return AggregatedHttpResponse.of((HttpStatus)HttpStatus.BAD_REQUEST, (MediaType)MediaType.ANY_TEXT_TYPE, (String)"traceIds is empty or null");
        }
        LinkedHashSet<String> normalizeTraceIds = new LinkedHashSet<String>();
        for (String traceId : traceIdsArr = traceIds.split(",", 1000)) {
            if (normalizeTraceIds.add(Span.normalizeTraceId((String)traceId.trim()))) continue;
            return AggregatedHttpResponse.of((HttpStatus)HttpStatus.BAD_REQUEST, (MediaType)MediaType.ANY_TEXT_TYPE, (String)("traceId: " + traceId + " duplicate "));
        }
        List traces = this.getZipkinQueryDAO().getTraces(normalizeTraceIds);
        return this.response(this.encodeTraces(traces));
    }

    @Get(value="/api/v2/autocompleteKeys")
    @Blocking
    public AggregatedHttpResponse getAutocompleteKeys() throws IOException {
        long endTimeMillis = System.currentTimeMillis();
        long startTimeMillis = endTimeMillis - this.defaultLookback;
        Set autocompleteKeys = this.getTagQueryService().queryTagAutocompleteKeys(TagType.ZIPKIN, TimeBucket.getTimeBucket((long)startTimeMillis, (DownSampling)DownSampling.Second), TimeBucket.getTimeBucket((long)endTimeMillis, (DownSampling)DownSampling.Second));
        return this.cachedResponse(true, new ArrayList<String>(autocompleteKeys));
    }

    @Get(value="/api/v2/autocompleteValues")
    @Blocking
    public AggregatedHttpResponse getAutocompleteValues(@Param(value="key") String key) throws IOException {
        long endTimeMillis = System.currentTimeMillis();
        long startTimeMillis = endTimeMillis - this.defaultLookback;
        Set autocompleteValues = this.getTagQueryService().queryTagAutocompleteValues(TagType.ZIPKIN, key, TimeBucket.getTimeBucket((long)startTimeMillis, (DownSampling)DownSampling.Second), TimeBucket.getTimeBucket((long)endTimeMillis, (DownSampling)DownSampling.Second));
        return this.cachedResponse(autocompleteValues.size() > 3, new ArrayList<String>(autocompleteValues));
    }

    private AggregatedHttpResponse response(byte[] body) {
        return AggregatedHttpResponse.of((ResponseHeaders)ResponseHeaders.builder((HttpStatus)HttpStatus.OK).contentType(MediaType.JSON).build(), (HttpData)HttpData.wrap((byte[])body));
    }

    private AggregatedHttpResponse cachedResponse(boolean shouldCache, List<String> values) {
        Collections.sort(values);
        ResponseHeadersBuilder headers = ResponseHeaders.builder((HttpStatus)HttpStatus.OK).contentType(MediaType.JSON);
        if (shouldCache) {
            headers = headers.add((CharSequence)HttpHeaderNames.CACHE_CONTROL, "max-age=" + this.namesMaxAge + ", must-revalidate");
        }
        return AggregatedHttpResponse.of((ResponseHeaders)headers.build(), (HttpData)HttpData.ofUtf8((String)GSON.toJson(values)));
    }

    private byte[] encodeTraces(List<List<Span>> traces) {
        if (CollectionUtils.isEmpty(traces)) {
            return new byte[]{91, 93};
        }
        ArrayList<byte[]> encodedTraces = new ArrayList<byte[]>(traces.size());
        int tracesSize = traces.size();
        int length = 0;
        for (List<Span> trace : traces) {
            byte[] traceByte = SpanBytesEncoder.JSON_V2.encodeList(trace);
            encodedTraces.add(traceByte);
            length += traceByte.length;
        }
        byte[] allByteArray = new byte[length + 2 + traces.size() - 1];
        ByteBuffer buff = ByteBuffer.wrap(allByteArray);
        buff.put((byte)91);
        for (int i = 0; i < tracesSize; ++i) {
            buff.put((byte[])encodedTraces.get(i));
            if (i >= tracesSize - 1) continue;
            buff.put((byte)44);
        }
        buff.put((byte)93);
        return buff.array();
    }
}

