/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.zipkin;

import com.linecorp.armeria.common.HttpMethod;
import java.util.Collections;
import org.apache.skywalking.oap.query.zipkin.ZipkinQueryConfig;
import org.apache.skywalking.oap.query.zipkin.ZipkinQueryModule;
import org.apache.skywalking.oap.query.zipkin.handler.ZipkinQueryHandler;
import org.apache.skywalking.oap.server.library.module.ModuleConfig;
import org.apache.skywalking.oap.server.library.module.ModuleDefine;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;
import org.apache.skywalking.oap.server.library.server.http.HTTPServer;
import org.apache.skywalking.oap.server.library.server.http.HTTPServerConfig;

public class ZipkinQueryProvider
extends ModuleProvider {
    public static final String NAME = "default";
    private final ZipkinQueryConfig config = new ZipkinQueryConfig();
    private HTTPServer httpServer;

    public String name() {
        return NAME;
    }

    public Class<? extends ModuleDefine> module() {
        return ZipkinQueryModule.class;
    }

    public ModuleConfig createConfigBeanIfAbsent() {
        return this.config;
    }

    public void prepare() throws ServiceNotProvidedException {
    }

    public void start() throws ServiceNotProvidedException, ModuleStartException {
        HTTPServerConfig httpServerConfig = HTTPServerConfig.builder().host(this.config.getRestHost()).port(this.config.getRestPort()).contextPath(this.config.getRestContextPath()).idleTimeOut(this.config.getRestIdleTimeOut()).maxThreads(this.config.getRestMaxThreads()).acceptQueueSize(this.config.getRestAcceptQueueSize()).build();
        this.httpServer = new HTTPServer(httpServerConfig);
        this.httpServer.initialize();
        this.httpServer.addHandler((Object)new ZipkinQueryHandler(this.config, this.getManager()), Collections.singletonList(HttpMethod.GET));
    }

    public void notifyAfterCompleted() {
        this.httpServer.start();
    }

    public String[] requiredModules() {
        return new String[]{"telemetry", "core"};
    }
}

