/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.skywalking.library.elasticsearch.requests.search.BoolQueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Query;
import org.apache.skywalking.library.elasticsearch.requests.search.QueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Search;
import org.apache.skywalking.library.elasticsearch.requests.search.SearchBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Sort;
import org.apache.skywalking.library.elasticsearch.response.search.SearchHit;
import org.apache.skywalking.library.elasticsearch.response.search.SearchResponse;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.query.enumeration.Order;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.input.TopNCondition;
import org.apache.skywalking.oap.server.core.query.type.SelectedRecord;
import org.apache.skywalking.oap.server.core.storage.query.ITopNRecordsQueryDAO;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.IndexController;

public class TopNRecordsQueryEsDAO
extends EsDAO
implements ITopNRecordsQueryDAO {
    public TopNRecordsQueryEsDAO(ElasticSearchClient client) {
        super(client);
    }

    public List<SelectedRecord> readSampledRecords(TopNCondition condition, String valueColumnName, Duration duration) throws IOException {
        BoolQueryBuilder query = Query.bool().must((QueryBuilder)Query.range((String)"time_bucket").gte((Object)duration.getStartTimeBucketInSec()).lte((Object)duration.getEndTimeBucketInSec()));
        if (IndexController.LogicIndicesRegister.isPhysicalTable(condition.getName())) {
            query.must((QueryBuilder)Query.term((String)"record_table", (Object)condition.getName()));
        }
        if (StringUtil.isNotEmpty((String)condition.getParentService())) {
            String serviceId = IDManager.ServiceID.buildId((String)condition.getParentService(), (boolean)condition.isNormal());
            query.must((QueryBuilder)Query.term((String)"service_id", (Object)serviceId));
        }
        SearchBuilder search = Search.builder().query((QueryBuilder)query).size(Integer.valueOf(condition.getTopN())).sort(valueColumnName, condition.getOrder().equals((Object)Order.DES) ? Sort.Order.DESC : Sort.Order.ASC);
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search(IndexController.LogicIndicesRegister.getPhysicalTableName(condition.getName()), search.build());
        ArrayList<SelectedRecord> results = new ArrayList<SelectedRecord>(condition.getTopN());
        for (SearchHit searchHit : response.getHits().getHits()) {
            SelectedRecord record = new SelectedRecord();
            Map sourceAsMap = searchHit.getSource();
            record.setName((String)sourceAsMap.get("statement"));
            record.setRefId((String)sourceAsMap.get("trace_id"));
            record.setId(record.getRefId());
            record.setValue(sourceAsMap.get(valueColumnName).toString());
            results.add(record);
        }
        return results;
    }
}

