/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.skywalking.library.elasticsearch.requests.search.BoolQueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Query;
import org.apache.skywalking.library.elasticsearch.requests.search.QueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Search;
import org.apache.skywalking.library.elasticsearch.requests.search.SearchBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Sort;
import org.apache.skywalking.library.elasticsearch.requests.search.aggregation.Aggregation;
import org.apache.skywalking.library.elasticsearch.requests.search.aggregation.AggregationBuilder;
import org.apache.skywalking.library.elasticsearch.response.search.SearchHit;
import org.apache.skywalking.library.elasticsearch.response.search.SearchResponse;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.manual.segment.SegmentRecord;
import org.apache.skywalking.oap.server.core.profiling.trace.ProfileThreadSnapshotRecord;
import org.apache.skywalking.oap.server.core.query.type.BasicTrace;
import org.apache.skywalking.oap.server.core.storage.profiling.trace.IProfileThreadSnapshotQueryDAO;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.library.util.BooleanUtils;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.ElasticSearchConverter;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.IndexController;

public class ProfileThreadSnapshotQueryEsDAO
extends EsDAO
implements IProfileThreadSnapshotQueryDAO {
    private final int querySegmentMaxSize;
    protected final ProfileThreadSnapshotRecord.Builder builder = new ProfileThreadSnapshotRecord.Builder();

    public ProfileThreadSnapshotQueryEsDAO(ElasticSearchClient client, int profileTaskQueryMaxSize) {
        super(client);
        this.querySegmentMaxSize = profileTaskQueryMaxSize;
    }

    public List<BasicTrace> queryProfiledSegments(String taskId) {
        BoolQueryBuilder segmentIdQuery = Query.bool().must((QueryBuilder)Query.term((String)"task_id", (Object)taskId)).must((QueryBuilder)Query.term((String)"sequence", (Object)0));
        if (IndexController.LogicIndicesRegister.isPhysicalTable("profile_task_segment_snapshot")) {
            segmentIdQuery.must((QueryBuilder)Query.term((String)"record_table", (Object)"profile_task_segment_snapshot"));
        }
        SearchBuilder search = Search.builder().query((QueryBuilder)segmentIdQuery).size(Integer.valueOf(this.querySegmentMaxSize)).sort("dump_time", Sort.Order.DESC);
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search(IndexController.LogicIndicesRegister.getPhysicalTableName("profile_task_segment_snapshot"), search.build());
        LinkedList<String> segmentIds = new LinkedList<String>();
        for (Object searchHit : response.getHits().getHits()) {
            segmentIds.add((String)searchHit.getSource().get("segment_id"));
        }
        if (CollectionUtils.isEmpty(segmentIds)) {
            return Collections.emptyList();
        }
        BoolQueryBuilder traceQuery = Query.bool();
        for (String segmentId : segmentIds) {
            traceQuery.should((QueryBuilder)Query.term((String)"segment_id", (Object)segmentId));
        }
        SearchBuilder traceSearch = Search.builder().query((QueryBuilder)traceQuery).size(Integer.valueOf(segmentIds.size())).sort("start_time", Sort.Order.DESC);
        response = ((ElasticSearchClient)this.getClient()).search("segment", traceSearch.build());
        ArrayList<BasicTrace> result = new ArrayList<BasicTrace>();
        for (SearchHit searchHit : response.getHits().getHits()) {
            BasicTrace basicTrace = new BasicTrace();
            basicTrace.setSegmentId((String)searchHit.getSource().get("segment_id"));
            basicTrace.setStart(String.valueOf(searchHit.getSource().get("start_time")));
            basicTrace.getEndpointNames().add(IDManager.EndpointID.analysisId((String)((String)searchHit.getSource().get("endpoint_id"))).getEndpointName());
            basicTrace.setDuration(((Number)searchHit.getSource().get("latency")).intValue());
            basicTrace.setError(BooleanUtils.valueToBoolean((int)((Number)searchHit.getSource().get("is_error")).intValue()));
            basicTrace.getTraceIds().add((String)searchHit.getSource().get("trace_id"));
            result.add(basicTrace);
        }
        return result;
    }

    public int queryMinSequence(String segmentId, long start, long end) {
        return this.querySequenceWithAgg((AggregationBuilder)Aggregation.min((String)"sequence").field("sequence"), segmentId, start, end);
    }

    public int queryMaxSequence(String segmentId, long start, long end) {
        return this.querySequenceWithAgg((AggregationBuilder)Aggregation.max((String)"sequence").field("sequence"), segmentId, start, end);
    }

    public List<ProfileThreadSnapshotRecord> queryRecords(String segmentId, int minSequence, int maxSequence) {
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName("profile_task_segment_snapshot");
        BoolQueryBuilder query = Query.bool().must((QueryBuilder)Query.term((String)"segment_id", (Object)segmentId)).must((QueryBuilder)Query.range((String)"sequence").gte((Object)minSequence).lt((Object)maxSequence));
        SearchBuilder search = Search.builder().query((QueryBuilder)query).size(Integer.valueOf(maxSequence - minSequence));
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search(index, search.build());
        ArrayList<ProfileThreadSnapshotRecord> result = new ArrayList<ProfileThreadSnapshotRecord>(maxSequence - minSequence);
        for (SearchHit searchHit : response.getHits().getHits()) {
            ProfileThreadSnapshotRecord record = this.builder.storage2Entity((Convert2Entity)new ElasticSearchConverter.ToEntity("profile_task_segment_snapshot", searchHit.getSource()));
            result.add(record);
        }
        return result;
    }

    public SegmentRecord getProfiledSegment(String segmentId) {
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName("segment");
        SearchBuilder search = Search.builder().query((QueryBuilder)Query.term((String)"segment_id", (Object)segmentId)).size(Integer.valueOf(1));
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search(index, search.build());
        if (response.getHits().getHits().isEmpty()) {
            return null;
        }
        SearchHit searchHit = (SearchHit)response.getHits().iterator().next();
        SegmentRecord segmentRecord = new SegmentRecord();
        segmentRecord.setSegmentId((String)searchHit.getSource().get("segment_id"));
        segmentRecord.setTraceId((String)searchHit.getSource().get("trace_id"));
        segmentRecord.setServiceId((String)searchHit.getSource().get("service_id"));
        segmentRecord.setStartTime(((Number)searchHit.getSource().get("start_time")).longValue());
        segmentRecord.setLatency(((Number)searchHit.getSource().get("latency")).intValue());
        segmentRecord.setIsError(((Number)searchHit.getSource().get("is_error")).intValue());
        String dataBinaryBase64 = (String)searchHit.getSource().get("data_binary");
        if (!Strings.isNullOrEmpty((String)dataBinaryBase64)) {
            segmentRecord.setDataBinary(Base64.getDecoder().decode(dataBinaryBase64));
        }
        return segmentRecord;
    }

    protected int querySequenceWithAgg(AggregationBuilder aggregationBuilder, String segmentId, long start, long end) {
        BoolQueryBuilder query = Query.bool().must((QueryBuilder)Query.term((String)"segment_id", (Object)segmentId)).must((QueryBuilder)Query.range((String)"dump_time").gte((Object)start).lte((Object)end));
        SearchBuilder search = Search.builder().query((QueryBuilder)query).size(Integer.valueOf(0)).aggregation(aggregationBuilder);
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName("profile_task_segment_snapshot");
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search(index, search.build());
        Map agg = (Map)response.getAggregations().get("sequence");
        return ((Number)agg.get("value")).intValue();
    }
}

