/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.skywalking.library.elasticsearch.requests.search.BoolQueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Query;
import org.apache.skywalking.library.elasticsearch.requests.search.QueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Search;
import org.apache.skywalking.library.elasticsearch.requests.search.SearchBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Sort;
import org.apache.skywalking.library.elasticsearch.response.search.SearchHit;
import org.apache.skywalking.library.elasticsearch.response.search.SearchResponse;
import org.apache.skywalking.oap.server.core.query.type.ProfileTask;
import org.apache.skywalking.oap.server.core.storage.profiling.trace.IProfileTaskQueryDAO;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.IndexController;

public class ProfileTaskQueryEsDAO
extends EsDAO
implements IProfileTaskQueryDAO {
    private final int queryMaxSize;

    public ProfileTaskQueryEsDAO(ElasticSearchClient client, int queryMaxSize) {
        super(client);
        this.queryMaxSize = queryMaxSize;
    }

    public List<ProfileTask> getTaskList(String serviceId, String endpointName, Long startTimeBucket, Long endTimeBucket, Integer limit) throws IOException {
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName("profile_task");
        BoolQueryBuilder query = Query.bool();
        if (IndexController.LogicIndicesRegister.isPhysicalTable("profile_task")) {
            query.must((QueryBuilder)Query.term((String)"record_table", (Object)"profile_task"));
        }
        if (StringUtil.isNotEmpty((String)serviceId)) {
            query.must((QueryBuilder)Query.term((String)"service_id", (Object)serviceId));
        }
        if (StringUtil.isNotEmpty((String)endpointName)) {
            query.must((QueryBuilder)Query.term((String)"endpoint_name", (Object)endpointName));
        }
        if (startTimeBucket != null) {
            query.must((QueryBuilder)Query.range((String)"time_bucket").gte((Object)startTimeBucket));
        }
        if (endTimeBucket != null) {
            query.must((QueryBuilder)Query.range((String)"time_bucket").lte((Object)endTimeBucket));
        }
        SearchBuilder search = Search.builder().query((QueryBuilder)query);
        if (limit != null) {
            search.size(limit);
        } else {
            search.size(Integer.valueOf(this.queryMaxSize));
        }
        search.sort("start_time", Sort.Order.DESC);
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search(index, search.build());
        LinkedList<ProfileTask> tasks = new LinkedList<ProfileTask>();
        for (SearchHit searchHit : response.getHits()) {
            tasks.add(this.parseTask(searchHit));
        }
        return tasks;
    }

    public ProfileTask getById(String id) throws IOException {
        if (StringUtil.isEmpty((String)id)) {
            return null;
        }
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName("profile_task");
        SearchBuilder search = Search.builder().query((QueryBuilder)Query.bool().must((QueryBuilder)Query.term((String)"task_id", (Object)id))).size(Integer.valueOf(1));
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search(index, search.build());
        if (response.getHits().getHits().size() > 0) {
            return this.parseTask((SearchHit)response.getHits().getHits().iterator().next());
        }
        return null;
    }

    private ProfileTask parseTask(SearchHit data) {
        Map source = data.getSource();
        return ProfileTask.builder().id((String)source.get("task_id")).serviceId((String)source.get("service_id")).endpointName((String)source.get("endpoint_name")).startTime(((Number)source.get("start_time")).longValue()).createTime(((Number)source.get("create_time")).longValue()).duration(((Number)source.get("duration")).intValue()).minDurationThreshold(((Number)source.get("min_duration_threshold")).intValue()).dumpPeriod(((Number)source.get("dump_period")).intValue()).maxSamplingCount(((Number)source.get("max_sampling_count")).intValue()).build();
    }
}

