/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query;

import java.io.IOException;
import java.util.Objects;
import org.apache.skywalking.library.elasticsearch.requests.search.BoolQueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Query;
import org.apache.skywalking.library.elasticsearch.requests.search.QueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Search;
import org.apache.skywalking.library.elasticsearch.requests.search.SearchBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Sort;
import org.apache.skywalking.library.elasticsearch.response.search.SearchHit;
import org.apache.skywalking.library.elasticsearch.response.search.SearchResponse;
import org.apache.skywalking.oap.server.core.browser.source.BrowserErrorCategory;
import org.apache.skywalking.oap.server.core.query.type.BrowserErrorLog;
import org.apache.skywalking.oap.server.core.query.type.BrowserErrorLogs;
import org.apache.skywalking.oap.server.core.storage.query.IBrowserLogQueryDAO;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.IndexController;

public class BrowserLogQueryEsDAO
extends EsDAO
implements IBrowserLogQueryDAO {
    public BrowserLogQueryEsDAO(ElasticSearchClient client) {
        super(client);
    }

    public BrowserErrorLogs queryBrowserErrorLogs(String serviceId, String serviceVersionId, String pagePathId, BrowserErrorCategory category, long startSecondTB, long endSecondTB, int limit, int from) throws IOException {
        BoolQueryBuilder boolQueryBuilder = Query.bool();
        if (IndexController.LogicIndicesRegister.isPhysicalTable("browser_error_log")) {
            boolQueryBuilder.must((QueryBuilder)Query.term((String)"record_table", (Object)"browser_error_log"));
        }
        if (startSecondTB != 0L && endSecondTB != 0L) {
            boolQueryBuilder.must((QueryBuilder)Query.range((String)"time_bucket").gte((Object)startSecondTB).lte((Object)endSecondTB));
        }
        if (StringUtil.isNotEmpty((String)serviceId)) {
            boolQueryBuilder.must((QueryBuilder)Query.term((String)"service_id", (Object)serviceId));
        }
        if (StringUtil.isNotEmpty((String)serviceVersionId)) {
            boolQueryBuilder.must((QueryBuilder)Query.term((String)"service_version_id", (Object)serviceVersionId));
        }
        if (StringUtil.isNotEmpty((String)pagePathId)) {
            boolQueryBuilder.must((QueryBuilder)Query.term((String)"page_path_id", (Object)pagePathId));
        }
        if (Objects.nonNull(category)) {
            boolQueryBuilder.must((QueryBuilder)Query.term((String)"error_category", (Object)category.getValue()));
        }
        SearchBuilder sourceBuilder = Search.builder().query((QueryBuilder)boolQueryBuilder).sort("timestamp", Sort.Order.DESC).size(Integer.valueOf(limit)).from(Integer.valueOf(from));
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search(IndexController.LogicIndicesRegister.getPhysicalTableName("browser_error_log"), sourceBuilder.build());
        BrowserErrorLogs logs = new BrowserErrorLogs();
        for (SearchHit searchHit : response.getHits().getHits()) {
            String dataBinaryBase64 = (String)searchHit.getSource().get("data_binary");
            if (!Objects.nonNull(dataBinaryBase64)) continue;
            BrowserErrorLog log = this.parserDataBinary(dataBinaryBase64);
            logs.getLogs().add(log);
        }
        return logs;
    }
}

