/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.skywalking.library.elasticsearch.requests.search.BoolQueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Query;
import org.apache.skywalking.library.elasticsearch.requests.search.QueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Search;
import org.apache.skywalking.library.elasticsearch.requests.search.SearchBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Sort;
import org.apache.skywalking.library.elasticsearch.response.search.SearchHit;
import org.apache.skywalking.library.elasticsearch.response.search.SearchResponse;
import org.apache.skywalking.oap.server.core.alarm.AlarmRecord;
import org.apache.skywalking.oap.server.core.analysis.manual.searchtag.Tag;
import org.apache.skywalking.oap.server.core.query.enumeration.Scope;
import org.apache.skywalking.oap.server.core.query.type.AlarmMessage;
import org.apache.skywalking.oap.server.core.query.type.Alarms;
import org.apache.skywalking.oap.server.core.storage.query.IAlarmQueryDAO;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.ElasticSearchConverter;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.IndexController;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.MatchCNameBuilder;

public class AlarmQueryEsDAO
extends EsDAO
implements IAlarmQueryDAO {
    public AlarmQueryEsDAO(ElasticSearchClient client) {
        super(client);
    }

    public Alarms getAlarm(Integer scopeId, String keyword, int limit, int from, long startTB, long endTB, List<Tag> tags) throws IOException {
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName("alarm_record");
        BoolQueryBuilder query = Query.bool();
        if (IndexController.LogicIndicesRegister.isPhysicalTable("alarm_record")) {
            query.must((QueryBuilder)Query.term((String)"record_table", (Object)"alarm_record"));
        }
        if (startTB != 0L && endTB != 0L) {
            query.must((QueryBuilder)Query.range((String)"time_bucket").gte((Object)startTB).lte((Object)endTB));
        }
        if (Objects.nonNull(scopeId)) {
            query.must((QueryBuilder)Query.term((String)"scope", (Object)scopeId));
        }
        if (!Strings.isNullOrEmpty((String)keyword)) {
            String matchCName = MatchCNameBuilder.INSTANCE.build("alarm_message");
            query.must((QueryBuilder)Query.matchPhrase((String)matchCName, (String)keyword));
        }
        if (CollectionUtils.isNotEmpty(tags)) {
            tags.forEach(tag -> query.must((QueryBuilder)Query.term((String)"tags", (Object)tag.toString())));
        }
        SearchBuilder search = Search.builder().query((QueryBuilder)query).size(Integer.valueOf(limit)).from(Integer.valueOf(from)).sort("start_time", Sort.Order.DESC);
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search(index, search.build());
        Alarms alarms = new Alarms();
        for (SearchHit searchHit : response.getHits().getHits()) {
            AlarmRecord.Builder builder = new AlarmRecord.Builder();
            AlarmRecord alarmRecord = builder.storage2Entity((Convert2Entity)new ElasticSearchConverter.ToEntity("alarm_record", searchHit.getSource()));
            AlarmMessage message = new AlarmMessage();
            message.setId(String.valueOf(alarmRecord.getId0()));
            message.setId1(String.valueOf(alarmRecord.getId1()));
            message.setMessage(alarmRecord.getAlarmMessage());
            message.setStartTime(Long.valueOf(alarmRecord.getStartTime()));
            message.setScope(Scope.Finder.valueOf((int)alarmRecord.getScope()));
            message.setScopeId(alarmRecord.getScope());
            if (!CollectionUtils.isEmpty((byte[])alarmRecord.getTagsRawData())) {
                this.parserDataBinary(alarmRecord.getTagsRawData(), message.getTags());
            }
            alarms.getMsgs().add(message);
        }
        return alarms;
    }
}

