/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.cache;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.library.elasticsearch.requests.search.BoolQueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Query;
import org.apache.skywalking.library.elasticsearch.requests.search.QueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Search;
import org.apache.skywalking.library.elasticsearch.requests.search.SearchParams;
import org.apache.skywalking.library.elasticsearch.response.search.SearchHit;
import org.apache.skywalking.library.elasticsearch.response.search.SearchResponse;
import org.apache.skywalking.oap.server.core.analysis.manual.networkalias.NetworkAddressAlias;
import org.apache.skywalking.oap.server.core.storage.cache.INetworkAddressAliasDAO;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.StorageModuleElasticsearchConfig;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.ElasticSearchConverter;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.IndexController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkAddressAliasEsDAO
extends EsDAO
implements INetworkAddressAliasDAO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NetworkAddressAliasEsDAO.class);
    protected final int resultWindowMaxSize;
    protected final int scrollingBatchSize;

    public NetworkAddressAliasEsDAO(ElasticSearchClient client, StorageModuleElasticsearchConfig config) {
        super(client);
        this.resultWindowMaxSize = config.getResultWindowMaxSize();
        this.scrollingBatchSize = config.getScrollingBatchSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<NetworkAddressAlias> loadLastUpdate(long timeBucketInMinute) {
        HashSet<String> scrollIds;
        SearchResponse results;
        NetworkAddressAlias.Builder builder;
        int batchSize;
        ArrayList<NetworkAddressAlias> networkAddressAliases;
        block7: {
            networkAddressAliases = new ArrayList<NetworkAddressAlias>();
            String index = IndexController.LogicIndicesRegister.getPhysicalTableName("network_address_alias");
            try {
                batchSize = Math.min(this.resultWindowMaxSize, this.scrollingBatchSize);
                BoolQueryBuilder query = Query.bool();
                if (IndexController.LogicIndicesRegister.isPhysicalTable("network_address_alias")) {
                    query.must((QueryBuilder)Query.term((String)"metric_table", (Object)"network_address_alias"));
                }
                query.must((QueryBuilder)Query.range((String)"last_update_time_bucket").gte((Object)timeBucketInMinute));
                Search search = Search.builder().query((QueryBuilder)query).size(Integer.valueOf(batchSize)).build();
                SearchParams params = new SearchParams().scroll(SCROLL_CONTEXT_RETENTION);
                builder = new NetworkAddressAlias.Builder();
                results = ((ElasticSearchClient)this.getClient()).search(index, search, params);
                scrollIds = new HashSet<String>();
                try {}
                catch (Throwable throwable) {
                    scrollIds.forEach(arg_0 -> ((ElasticSearchClient)((ElasticSearchClient)this.getClient())).deleteScrollContextQuietly(arg_0));
                    throw throwable;
                }
                break block7;
            }
            catch (Throwable t) {
                log.error(t.getMessage(), t);
            }
            return networkAddressAliases;
        }
        while (true) {
            String scrollId = results.getScrollId();
            scrollIds.add(scrollId);
            if (results.getHits().getTotal() == 0) break;
            for (SearchHit searchHit : results.getHits()) {
                networkAddressAliases.add(builder.storage2Entity((Convert2Entity)new ElasticSearchConverter.ToEntity("network_address_alias", searchHit.getSource())));
            }
            if (results.getHits().getTotal() < batchSize || networkAddressAliases.size() >= this.resultWindowMaxSize) break;
            results = ((ElasticSearchClient)this.getClient()).scroll(SCROLL_CONTEXT_RETENTION, scrollId);
        }
        scrollIds.forEach(arg_0 -> ((ElasticSearchClient)((ElasticSearchClient)this.getClient())).deleteScrollContextQuietly(arg_0));
        return networkAddressAliases;
    }
}

