/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base;

import com.google.gson.Gson;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.skywalking.library.elasticsearch.response.Index;
import org.apache.skywalking.library.elasticsearch.response.IndexTemplate;
import org.apache.skywalking.library.elasticsearch.response.Mappings;
import org.apache.skywalking.oap.server.core.storage.StorageException;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.storage.model.ModelColumn;
import org.apache.skywalking.oap.server.core.storage.model.ModelInstaller;
import org.apache.skywalking.oap.server.library.client.Client;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.StorageModuleElasticsearchConfig;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.AnalyzerSetting;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.ColumnTypeEsMapping;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.IndexController;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.IndexStructures;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.MatchCNameBuilder;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.TimeSeriesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageEsInstaller
extends ModelInstaller {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StorageEsInstaller.class);
    private final Gson gson = new Gson();
    private final StorageModuleElasticsearchConfig config;
    protected final ColumnTypeEsMapping columnTypeEsMapping = new ColumnTypeEsMapping();
    private final IndexStructures structures;

    public StorageEsInstaller(Client client, ModuleManager moduleManager, StorageModuleElasticsearchConfig config) {
        super(client, moduleManager);
        this.config = config;
        this.structures = this.getStructures();
    }

    protected IndexStructures getStructures() {
        return new IndexStructures();
    }

    protected boolean isExists(Model model) {
        boolean exist;
        ElasticSearchClient esClient = (ElasticSearchClient)this.client;
        String tableName = IndexController.INSTANCE.getTableName(model);
        IndexController.LogicIndicesRegister.registerRelation(model, tableName);
        if (!model.isTimeSeries()) {
            boolean exist2 = esClient.isExistsIndex(tableName);
            if (exist2) {
                Mappings historyMapping = esClient.getIndex(tableName).map(Index::getMappings).orElseGet(Mappings::new);
                this.structures.putStructure(tableName, historyMapping);
                exist2 = this.structures.containsStructure(tableName, this.createMapping(model));
            }
            return exist2;
        }
        boolean templateExists = esClient.isExistsTemplate(tableName);
        Optional template = esClient.getTemplate(tableName);
        boolean lastIndexExists = esClient.isExistsIndex(TimeSeriesUtils.latestWriteIndexName(model));
        if (templateExists && !template.isPresent() || !templateExists && template.isPresent()) {
            throw new Error("[Bug warning] ElasticSearch client query template result is not consistent. Please file an issue to Apache SkyWalking.(https://github.com/apache/skywalking/issues)");
        }
        boolean bl = exist = templateExists && lastIndexExists;
        if (exist) {
            this.structures.putStructure(tableName, ((IndexTemplate)template.get()).getMappings());
            exist = this.structures.containsStructure(tableName, this.createMapping(model));
        }
        return exist;
    }

    protected void createTable(Model model) throws StorageException {
        if (model.isTimeSeries()) {
            this.createTimeSeriesTable(model);
        } else {
            this.createNormalTable(model);
        }
    }

    private void createNormalTable(Model model) throws StorageException {
        ElasticSearchClient esClient = (ElasticSearchClient)this.client;
        String tableName = IndexController.INSTANCE.getTableName(model);
        Mappings mapping = this.createMapping(model);
        if (!esClient.isExistsIndex(tableName)) {
            Map<String, Object> settings = this.createSetting(model);
            boolean isAcknowledged = esClient.createIndex(tableName, mapping, settings);
            log.info("create {} index finished, isAcknowledged: {}", (Object)tableName, (Object)isAcknowledged);
            if (!isAcknowledged) {
                throw new StorageException("create " + tableName + " index failure, ");
            }
        } else {
            Mappings historyMapping = esClient.getIndex(tableName).map(Index::getMappings).orElseGet(Mappings::new);
            this.structures.putStructure(tableName, mapping);
            Mappings appendMapping = this.structures.diffStructure(tableName, historyMapping);
            if (appendMapping.getProperties() != null && !appendMapping.getProperties().isEmpty()) {
                boolean isAcknowledged = esClient.updateIndexMapping(tableName, appendMapping);
                log.info("update {} index finished, isAcknowledged: {}, append mappings: {}", new Object[]{tableName, isAcknowledged, appendMapping});
                if (!isAcknowledged) {
                    throw new StorageException("update " + tableName + " index failure");
                }
            }
        }
    }

    private void createTimeSeriesTable(Model model) throws StorageException {
        ElasticSearchClient esClient = (ElasticSearchClient)this.client;
        String tableName = IndexController.INSTANCE.getTableName(model);
        Map<String, Object> settings = this.createSetting(model);
        Mappings mapping = this.createMapping(model);
        String indexName = TimeSeriesUtils.latestWriteIndexName(model);
        try {
            boolean isAcknowledged;
            boolean shouldUpdateTemplate = !esClient.isExistsTemplate(tableName);
            boolean bl = shouldUpdateTemplate = shouldUpdateTemplate || !this.structures.containsStructure(tableName, mapping);
            if (shouldUpdateTemplate) {
                this.structures.putStructure(tableName, mapping);
                isAcknowledged = esClient.createOrUpdateTemplate(tableName, settings, this.structures.getMapping(tableName), this.config.getIndexTemplateOrder());
                log.info("create {} index template finished, isAcknowledged: {}", (Object)tableName, (Object)isAcknowledged);
                if (!isAcknowledged) {
                    throw new IOException("create " + tableName + " index template failure");
                }
            }
            if (esClient.isExistsIndex(indexName)) {
                Mappings historyMapping = esClient.getIndex(indexName).map(Index::getMappings).orElseGet(Mappings::new);
                Mappings appendMapping = this.structures.diffStructure(tableName, historyMapping);
                if (appendMapping.getProperties() != null && !appendMapping.getProperties().isEmpty()) {
                    boolean isAcknowledged2 = esClient.updateIndexMapping(indexName, appendMapping);
                    log.info("update {} index finished, isAcknowledged: {}, append mappings: {}", new Object[]{indexName, isAcknowledged2, appendMapping});
                    if (!isAcknowledged2) {
                        throw new StorageException("update " + indexName + " time series index failure");
                    }
                }
            } else {
                isAcknowledged = esClient.createIndex(indexName);
                log.info("create {} index finished, isAcknowledged: {}", (Object)indexName, (Object)isAcknowledged);
                if (!isAcknowledged) {
                    throw new StorageException("create " + indexName + " time series index failure");
                }
            }
        }
        catch (IOException e) {
            throw new StorageException("cannot create " + tableName + " index template", (Throwable)e);
        }
    }

    protected Map<String, Object> createSetting(Model model) throws StorageException {
        HashMap<String, Object> setting = new HashMap<String, Object>();
        setting.put("index.number_of_replicas", model.isSuperDataset() ? this.config.getSuperDatasetIndexReplicasNumber() : this.config.getIndexReplicasNumber());
        setting.put("index.number_of_shards", model.isSuperDataset() ? this.config.getIndexShardsNumber() * this.config.getSuperDatasetIndexShardsFactor() : this.config.getIndexShardsNumber());
        int indexRefreshInterval = this.config.getFlushInterval() * 2 / 3;
        if (indexRefreshInterval < 5) {
            indexRefreshInterval = 5;
        }
        setting.put("index.refresh_interval", indexRefreshInterval + "s");
        List<ModelColumn> columns = IndexController.LogicIndicesRegister.getPhysicalTableColumns(model);
        setting.put("analysis", this.getAnalyzerSetting(columns));
        if (!StringUtil.isEmpty((String)this.config.getAdvanced())) {
            Map advancedSettings = (Map)this.gson.fromJson(this.config.getAdvanced(), Map.class);
            setting.putAll(advancedSettings);
        }
        return setting;
    }

    private Map getAnalyzerSetting(List<ModelColumn> analyzerTypes) throws StorageException {
        AnalyzerSetting analyzerSetting = new AnalyzerSetting();
        for (ModelColumn column : analyzerTypes) {
            if (!column.getElasticSearchExtension().needMatchQuery()) continue;
            AnalyzerSetting setting = AnalyzerSetting.Generator.getGenerator(column.getElasticSearchExtension().getAnalyzer()).getGenerateFunc().generate(this.config);
            analyzerSetting.combine(setting);
        }
        return (Map)this.gson.fromJson(this.gson.toJson((Object)analyzerSetting), Map.class);
    }

    protected Mappings createMapping(Model model) {
        HashMap<String, String> column;
        HashMap properties = new HashMap();
        Mappings.Source source = new Mappings.Source();
        for (ModelColumn columnDefine : model.getColumns()) {
            String type = this.columnTypeEsMapping.transform(columnDefine.getType(), columnDefine.getGenericType());
            String columnName = columnDefine.getColumnName().getName();
            String alias = columnDefine.getElasticSearchExtension().getColumnAlias();
            if (!this.config.isLogicSharding() && alias != null) {
                columnName = alias;
            }
            if (columnDefine.getElasticSearchExtension().needMatchQuery()) {
                String matchCName = MatchCNameBuilder.INSTANCE.build(columnName);
                HashMap<String, String> originalColumn = new HashMap<String, String>();
                originalColumn.put("type", type);
                originalColumn.put("copy_to", matchCName);
                properties.put(columnName, originalColumn);
                HashMap<String, String> matchColumn = new HashMap<String, String>();
                matchColumn.put("type", "text");
                matchColumn.put("analyzer", columnDefine.getElasticSearchExtension().getAnalyzer().getName());
                properties.put(matchCName, matchColumn);
            } else {
                HashMap<String, Object> column2 = new HashMap<String, Object>();
                column2.put("type", type);
                if (columnDefine.isStorageOnly() && !"binary".equals(type)) {
                    column2.put("index", false);
                }
                properties.put(columnName, column2);
            }
            if (!columnDefine.isIndexOnly()) continue;
            source.getExcludes().add(columnName);
        }
        if (IndexController.INSTANCE.isMetricModel(model) && !this.config.isLogicSharding() || this.config.isLogicSharding() && IndexController.INSTANCE.isFunctionMetric(model)) {
            column = new HashMap<String, String>();
            column.put("type", "keyword");
            properties.put("metric_table", column);
        }
        if (!this.config.isLogicSharding() && IndexController.INSTANCE.isRecordModel(model) && !model.isSuperDataset()) {
            column = new HashMap();
            column.put("type", "keyword");
            properties.put("record_table", column);
        }
        Mappings mappings = Mappings.builder().type("type").properties(properties).source(source).build();
        log.debug("elasticsearch index template setting: {}", (Object)mappings.toString());
        return mappings;
    }
}

