/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base;

import java.io.IOException;
import java.util.Map;
import org.apache.skywalking.oap.server.core.analysis.config.NoneStream;
import org.apache.skywalking.oap.server.core.storage.INoneStreamDAO;
import org.apache.skywalking.oap.server.core.storage.StorageData;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.ElasticSearchConverter;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.IndexController;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.TimeSeriesUtils;

public class NoneStreamEsDAO
extends EsDAO
implements INoneStreamDAO {
    private final StorageBuilder<NoneStream> storageBuilder;

    public NoneStreamEsDAO(ElasticSearchClient client, StorageBuilder<NoneStream> storageBuilder) {
        super(client);
        this.storageBuilder = storageBuilder;
    }

    public void insert(Model model, NoneStream noneStream) throws IOException {
        ElasticSearchConverter.ToStorage toStorage = new ElasticSearchConverter.ToStorage(model.getName());
        this.storageBuilder.entity2Storage((StorageData)noneStream, (Convert2Storage)toStorage);
        Map<String, Object> builder = IndexController.INSTANCE.appendTableColumn(model, (Map<String, Object>)toStorage.obtain());
        String modelName = TimeSeriesUtils.writeIndexName(model, noneStream.getTimeBucket());
        String id = IndexController.INSTANCE.generateDocId(model, noneStream.id());
        ((ElasticSearchClient)this.getClient()).forceInsert(modelName, id, builder);
    }
}

