/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.library.elasticsearch.response.search.SearchResponse;
import org.apache.skywalking.oap.server.core.analysis.DownSampling;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.storage.IMetricsDAO;
import org.apache.skywalking.oap.server.core.storage.StorageData;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.library.client.request.InsertRequest;
import org.apache.skywalking.oap.server.library.client.request.UpdateRequest;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.ElasticSearchConverter;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.IndexController;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.TimeSeriesUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsEsDAO
extends EsDAO
implements IMetricsDAO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetricsEsDAO.class);
    protected final StorageBuilder<Metrics> storageBuilder;

    public MetricsEsDAO(ElasticSearchClient client, StorageBuilder<Metrics> storageBuilder) {
        super(client);
        this.storageBuilder = storageBuilder;
    }

    public List<Metrics> multiGet(Model model, List<Metrics> metrics) {
        HashMap<String, List> groupIndices = new HashMap<String, List>();
        ArrayList<Metrics> result = new ArrayList<Metrics>(metrics.size());
        if (model.isTimeRelativeID()) {
            metrics.forEach(metric -> {
                String indexName = TimeSeriesUtils.writeIndexName(model, metric.getTimeBucket());
                groupIndices.computeIfAbsent(indexName, v -> new ArrayList()).add(metric);
            });
            HashMap indexIdsGroup = new HashMap();
            groupIndices.forEach((tableName, metricList) -> {
                List ids = metricList.stream().map(item -> IndexController.INSTANCE.generateDocId(model, item.id())).collect(Collectors.toList());
                indexIdsGroup.put(tableName, ids);
            });
            if (!indexIdsGroup.isEmpty()) {
                Optional response = ((ElasticSearchClient)this.getClient()).ids(indexIdsGroup);
                response.ifPresent(documents -> documents.forEach(document -> {
                    Metrics source = (Metrics)this.storageBuilder.storage2Entity((Convert2Entity)new ElasticSearchConverter.ToEntity(model.getName(), document.getSource()));
                    result.add(source);
                }));
            }
        } else {
            metrics.forEach(metric -> {
                String indexName = IndexController.INSTANCE.getTableName(model);
                groupIndices.computeIfAbsent(indexName, v -> new ArrayList()).add(metric);
            });
            groupIndices.forEach((tableName, metricList) -> {
                List ids = metricList.stream().map(item -> IndexController.INSTANCE.generateDocId(model, item.id())).collect(Collectors.toList());
                SearchResponse response = ((ElasticSearchClient)this.getClient()).searchIDs(tableName, ids);
                response.getHits().getHits().forEach(hit -> {
                    Metrics source = (Metrics)this.storageBuilder.storage2Entity((Convert2Entity)new ElasticSearchConverter.ToEntity(model.getName(), hit.getSource()));
                    result.add(source);
                });
            });
        }
        return result;
    }

    public InsertRequest prepareBatchInsert(Model model, Metrics metrics) {
        ElasticSearchConverter.ToStorage toStorage = new ElasticSearchConverter.ToStorage(model.getName());
        this.storageBuilder.entity2Storage((StorageData)metrics, (Convert2Storage)toStorage);
        Map<String, Object> builder = IndexController.INSTANCE.appendTableColumn(model, (Map<String, Object>)toStorage.obtain());
        String modelName = TimeSeriesUtils.writeIndexName(model, metrics.getTimeBucket());
        String id = IndexController.INSTANCE.generateDocId(model, metrics.id());
        return ((ElasticSearchClient)this.getClient()).prepareInsert(modelName, id, builder);
    }

    public UpdateRequest prepareBatchUpdate(Model model, Metrics metrics) {
        ElasticSearchConverter.ToStorage toStorage = new ElasticSearchConverter.ToStorage(model.getName());
        this.storageBuilder.entity2Storage((StorageData)metrics, (Convert2Storage)toStorage);
        Map<String, Object> builder = IndexController.INSTANCE.appendTableColumn(model, (Map<String, Object>)toStorage.obtain());
        String modelName = TimeSeriesUtils.writeIndexName(model, metrics.getTimeBucket());
        String id = IndexController.INSTANCE.generateDocId(model, metrics.id());
        return ((ElasticSearchClient)this.getClient()).prepareUpdate(modelName, id, builder);
    }

    public boolean isExpiredCache(Model model, Metrics cachedValue, long currentTimeMillis, int ttl) {
        long metricTimestamp = TimeBucket.getTimestamp((long)cachedValue.getTimeBucket(), (DownSampling)model.getDownsampling());
        if (currentTimeMillis - metricTimestamp < TimeUnit.DAYS.toMillis(ttl - 1)) {
            return false;
        }
        long deadline = Long.parseLong(new DateTime(currentTimeMillis).plusDays(-ttl).toString("yyyyMMdd"));
        long timeBucket = TimeBucket.getTimeBucket((long)metricTimestamp, (DownSampling)DownSampling.Day);
        return timeBucket <= deadline;
    }
}

