/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.skywalking.library.elasticsearch.response.Mappings;

public class IndexStructures {
    private final Map<String, Fields> structures = new HashMap<String, Fields>();

    public Mappings getMapping(String tableName) {
        HashMap properties = this.structures.containsKey(tableName) ? this.structures.get(tableName).properties : new HashMap();
        Mappings.Source source = this.structures.containsKey(tableName) ? this.structures.get(tableName).source : new Mappings.Source();
        return Mappings.builder().type("type").properties(properties).source(source).build();
    }

    public void putStructure(String tableName, Mappings mapping) {
        if (Objects.isNull(mapping) || Objects.isNull(mapping.getProperties()) || mapping.getProperties().isEmpty()) {
            return;
        }
        Fields fields = new Fields(mapping);
        if (this.structures.containsKey(tableName)) {
            this.structures.get(tableName).appendNewFields(fields);
        } else {
            this.structures.put(tableName, fields);
        }
    }

    public Mappings diffStructure(String tableName, Mappings mappings) {
        if (!this.structures.containsKey(tableName)) {
            return new Mappings();
        }
        Map properties = mappings.getProperties();
        Map diffProperties = this.structures.get(tableName).diffFields(new Fields(mappings));
        return Mappings.builder().type("type").properties(diffProperties).build();
    }

    public boolean containsStructure(String tableName, Mappings mappings) {
        if (Objects.isNull(mappings) || Objects.isNull(mappings.getProperties()) || mappings.getProperties().isEmpty()) {
            return true;
        }
        return this.structures.containsKey(tableName) && this.structures.get(tableName).containsAllFields(new Fields(mappings));
    }

    public static class Fields {
        private final Map<String, Object> properties;
        private Mappings.Source source;

        private Fields(Mappings mapping) {
            this.properties = mapping.getProperties();
            this.source = mapping.getSource();
        }

        private boolean containsAllFields(Fields fields) {
            if (this.properties.size() < fields.properties.size()) {
                return false;
            }
            boolean isContains = fields.properties.entrySet().stream().allMatch(item -> Objects.equals(this.properties.get(item.getKey()), item.getValue()));
            if (!isContains) {
                return false;
            }
            return fields.source.getExcludes().containsAll(this.source.getExcludes());
        }

        private void appendNewFields(Fields fields) {
            this.properties.putAll(fields.properties);
            this.source = fields.source;
        }

        private Map<String, Object> diffFields(Fields fields) {
            return this.properties.entrySet().stream().filter(e -> !fields.properties.containsKey(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
    }
}

