/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.apache.skywalking.library.elasticsearch.bulk.BulkProcessor;
import org.apache.skywalking.oap.server.core.storage.IBatchDAO;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.library.client.elasticsearch.IndexRequestWrapper;
import org.apache.skywalking.oap.server.library.client.elasticsearch.UpdateRequestWrapper;
import org.apache.skywalking.oap.server.library.client.request.InsertRequest;
import org.apache.skywalking.oap.server.library.client.request.PrepareRequest;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchProcessEsDAO
extends EsDAO
implements IBatchDAO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BatchProcessEsDAO.class);
    private volatile BulkProcessor bulkProcessor;
    private final int bulkActions;
    private final int flushInterval;
    private final int concurrentRequests;

    public BatchProcessEsDAO(ElasticSearchClient client, int bulkActions, int flushInterval, int concurrentRequests) {
        super(client);
        this.bulkActions = bulkActions;
        this.flushInterval = flushInterval;
        this.concurrentRequests = concurrentRequests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(InsertRequest insertRequest) {
        if (this.bulkProcessor == null) {
            BatchProcessEsDAO batchProcessEsDAO = this;
            synchronized (batchProcessEsDAO) {
                if (this.bulkProcessor == null) {
                    this.bulkProcessor = ((ElasticSearchClient)this.getClient()).createBulkProcessor(this.bulkActions, this.flushInterval, this.concurrentRequests);
                }
            }
        }
        this.bulkProcessor.add(((IndexRequestWrapper)insertRequest).getRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> flush(List<PrepareRequest> prepareRequests) {
        if (this.bulkProcessor == null) {
            BatchProcessEsDAO batchProcessEsDAO = this;
            synchronized (batchProcessEsDAO) {
                if (this.bulkProcessor == null) {
                    this.bulkProcessor = ((ElasticSearchClient)this.getClient()).createBulkProcessor(this.bulkActions, this.flushInterval, this.concurrentRequests);
                }
            }
        }
        if (CollectionUtils.isNotEmpty(prepareRequests)) {
            return CompletableFuture.allOf((CompletableFuture[])prepareRequests.stream().map(prepareRequest -> {
                if (prepareRequest instanceof InsertRequest) {
                    return this.bulkProcessor.add(((IndexRequestWrapper)prepareRequest).getRequest());
                }
                return this.bulkProcessor.add(((UpdateRequestWrapper)prepareRequest).getRequest());
            }).toArray(CompletableFuture[]::new));
        }
        return CompletableFuture.completedFuture(null);
    }

    public void endOfFlush() {
        this.bulkProcessor.flush();
    }
}

