/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.exporter.provider.grpc;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.metrics.DoubleValueHolder;
import org.apache.skywalking.oap.server.core.analysis.metrics.IntValueHolder;
import org.apache.skywalking.oap.server.core.analysis.metrics.LongValueHolder;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.MetricsMetaInfo;
import org.apache.skywalking.oap.server.core.analysis.metrics.MultiIntValuesHolder;
import org.apache.skywalking.oap.server.core.analysis.metrics.WithMetadata;
import org.apache.skywalking.oap.server.core.exporter.ExportData;
import org.apache.skywalking.oap.server.core.exporter.ExportEvent;
import org.apache.skywalking.oap.server.core.exporter.MetricValuesExportService;
import org.apache.skywalking.oap.server.exporter.grpc.EventType;
import org.apache.skywalking.oap.server.exporter.grpc.ExportMetricValue;
import org.apache.skywalking.oap.server.exporter.grpc.ExportResponse;
import org.apache.skywalking.oap.server.exporter.grpc.MetricExportServiceGrpc;
import org.apache.skywalking.oap.server.exporter.grpc.SubscriptionMetric;
import org.apache.skywalking.oap.server.exporter.grpc.SubscriptionReq;
import org.apache.skywalking.oap.server.exporter.grpc.SubscriptionsResp;
import org.apache.skywalking.oap.server.exporter.grpc.ValueType;
import org.apache.skywalking.oap.server.exporter.provider.MetricFormatter;
import org.apache.skywalking.oap.server.exporter.provider.grpc.GRPCExporterSetting;
import org.apache.skywalking.oap.server.library.client.grpc.GRPCClient;
import org.apache.skywalking.oap.server.library.datacarrier.DataCarrier;
import org.apache.skywalking.oap.server.library.datacarrier.consumer.IConsumer;
import org.apache.skywalking.oap.server.library.util.GRPCStreamStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GRPCExporter
extends MetricFormatter
implements MetricValuesExportService,
IConsumer<ExportData> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GRPCExporter.class);
    private static final long FETCH_SUBSCRIPTION_PERIOD = 30000L;
    private final GRPCExporterSetting setting;
    private final MetricExportServiceGrpc.MetricExportServiceStub exportServiceFutureStub;
    private final MetricExportServiceGrpc.MetricExportServiceBlockingStub blockingStub;
    private final DataCarrier exportBuffer;
    private final ReentrantLock fetchListLock;
    private volatile List<SubscriptionMetric> subscriptionList;
    private volatile long lastFetchTimestamp = 0L;

    public GRPCExporter(GRPCExporterSetting setting) {
        this.setting = setting;
        GRPCClient client = new GRPCClient(setting.getTargetHost(), setting.getTargetPort());
        client.connect();
        ManagedChannel channel = client.getChannel();
        this.exportServiceFutureStub = MetricExportServiceGrpc.newStub((Channel)channel);
        this.blockingStub = MetricExportServiceGrpc.newBlockingStub((Channel)channel);
        this.exportBuffer = new DataCarrier(setting.getBufferChannelNum(), setting.getBufferChannelSize());
        this.exportBuffer.consume((IConsumer)this, 1, 200L);
        this.subscriptionList = new ArrayList<SubscriptionMetric>();
        this.fetchListLock = new ReentrantLock();
    }

    public void export(ExportEvent event) {
        Metrics metrics = event.getMetrics();
        if (metrics instanceof WithMetadata) {
            MetricsMetaInfo meta = ((WithMetadata)metrics).getMeta();
            if (this.subscriptionList.size() == 0 && ExportEvent.EventType.INCREMENT.equals((Object)event.getType())) {
                this.exportBuffer.produce((Object)new ExportData(meta, metrics, event.getType()));
            } else {
                this.subscriptionList.forEach(subscriptionMetric -> {
                    if (subscriptionMetric.getMetricName().equals(meta.getMetricsName()) && this.eventTypeMatch(event.getType(), subscriptionMetric.getEventType())) {
                        this.exportBuffer.produce((Object)new ExportData(meta, metrics, event.getType()));
                    }
                });
            }
            this.fetchSubscriptionList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchSubscriptionList() {
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis - this.lastFetchTimestamp > 30000L) {
            this.fetchListLock.lock();
            try {
                if (currentTimeMillis - this.lastFetchTimestamp > 30000L) {
                    this.lastFetchTimestamp = currentTimeMillis;
                    SubscriptionsResp subscription = ((MetricExportServiceGrpc.MetricExportServiceBlockingStub)this.blockingStub.withDeadlineAfter(10L, TimeUnit.SECONDS)).subscription(SubscriptionReq.newBuilder().build());
                    this.subscriptionList = subscription.getMetricsList();
                    log.debug("Get exporter subscription list, {}", this.subscriptionList);
                }
            }
            catch (Throwable e) {
                log.error("Getting exporter subscription list fails.", e);
            }
            finally {
                this.fetchListLock.unlock();
            }
        }
    }

    public void init(Properties properties) {
    }

    public void consume(List<ExportData> data) {
        final GRPCStreamStatus status = new GRPCStreamStatus();
        StreamObserver<ExportMetricValue> streamObserver = ((MetricExportServiceGrpc.MetricExportServiceStub)this.exportServiceFutureStub.withDeadlineAfter(10L, TimeUnit.SECONDS)).export(new StreamObserver<ExportResponse>(){

            public void onNext(ExportResponse response) {
            }

            public void onError(Throwable throwable) {
                status.done();
            }

            public void onCompleted() {
                status.done();
            }
        });
        AtomicInteger exportNum = new AtomicInteger();
        data.forEach(row -> {
            ExportMetricValue.Builder builder = ExportMetricValue.newBuilder();
            Metrics metrics = row.getMetrics();
            if (metrics instanceof LongValueHolder) {
                long value = ((LongValueHolder)metrics).getValue();
                builder.setLongValue(value);
                builder.setType(ValueType.LONG);
            } else if (metrics instanceof IntValueHolder) {
                long value = ((IntValueHolder)metrics).getValue();
                builder.setLongValue(value);
                builder.setType(ValueType.LONG);
            } else if (metrics instanceof DoubleValueHolder) {
                double value = ((DoubleValueHolder)metrics).getValue();
                builder.setDoubleValue(value);
                builder.setType(ValueType.DOUBLE);
            } else if (metrics instanceof MultiIntValuesHolder) {
                int[] values;
                for (int value : values = ((MultiIntValuesHolder)metrics).getValues()) {
                    builder.addLongValues(value);
                }
                builder.setType(ValueType.MULTI_LONG);
            } else {
                return;
            }
            MetricsMetaInfo meta = row.getMeta();
            builder.setMetricName(meta.getMetricsName());
            builder.setEventType(ExportEvent.EventType.INCREMENT.equals((Object)row.getEventType()) ? EventType.INCREMENT : EventType.TOTAL);
            String entityName = this.getEntityName(meta);
            if (entityName == null) {
                return;
            }
            builder.setEntityName(entityName);
            builder.setEntityId(meta.getId());
            builder.setTimeBucket(metrics.getTimeBucket());
            streamObserver.onNext((Object)builder.build());
            exportNum.getAndIncrement();
        });
        streamObserver.onCompleted();
        long sleepTime = 0L;
        long cycle = 100L;
        while (!status.isDone()) {
            try {
                sleepTime += cycle;
                Thread.sleep(cycle);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (sleepTime <= 2000L) continue;
            log.warn("Export {} metrics to {}:{}, wait {} milliseconds.", new Object[]{exportNum.get(), this.setting.getTargetHost(), this.setting.getTargetPort(), sleepTime});
            cycle = 2000L;
        }
        log.debug("Exported {} metrics to {}:{} in {} milliseconds.", new Object[]{exportNum.get(), this.setting.getTargetHost(), this.setting.getTargetPort(), sleepTime});
        this.fetchSubscriptionList();
    }

    public void onError(List<ExportData> data, Throwable t) {
        log.error(t.getMessage(), t);
    }

    public void onExit() {
    }

    private boolean eventTypeMatch(ExportEvent.EventType eventType, EventType subscriptionType) {
        return ExportEvent.EventType.INCREMENT.equals((Object)eventType) && EventType.INCREMENT.equals((Object)subscriptionType) || ExportEvent.EventType.TOTAL.equals((Object)eventType) && EventType.TOTAL.equals((Object)subscriptionType);
    }
}

