/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.exporter.provider;

import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.metrics.MetricsEntityMetaInfo;
import org.apache.skywalking.oap.server.core.analysis.metrics.MetricsMetaInfo;
import org.apache.skywalking.oap.server.core.source.DefaultScopeDefine;

public class MetricFormatter {
    protected String getEntityName(MetricsMetaInfo meta) {
        int scope = meta.getScope();
        if (DefaultScopeDefine.inServiceCatalog((int)scope)) {
            String serviceId = meta.getId();
            IDManager.ServiceID.ServiceIDDefinition serviceIDDefinition = IDManager.ServiceID.analysisId((String)serviceId);
            return serviceIDDefinition.getName();
        }
        if (DefaultScopeDefine.inServiceInstanceCatalog((int)scope)) {
            String instanceId = meta.getId();
            IDManager.ServiceInstanceID.InstanceIDDefinition instanceIDDefinition = IDManager.ServiceInstanceID.analysisId((String)instanceId);
            return instanceIDDefinition.getName();
        }
        if (DefaultScopeDefine.inEndpointCatalog((int)scope)) {
            String endpointId = meta.getId();
            IDManager.EndpointID.EndpointIDDefinition endpointIDDefinition = IDManager.EndpointID.analysisId((String)endpointId);
            return endpointIDDefinition.getEndpointName();
        }
        if (DefaultScopeDefine.inServiceRelationCatalog((int)scope)) {
            String serviceRelationId = meta.getId();
            IDManager.ServiceID.ServiceRelationDefine serviceRelationDefine = IDManager.ServiceID.analysisRelationId((String)serviceRelationId);
            IDManager.ServiceID.ServiceIDDefinition sourceIdDefinition = IDManager.ServiceID.analysisId((String)serviceRelationDefine.getSourceId());
            IDManager.ServiceID.ServiceIDDefinition destIdDefinition = IDManager.ServiceID.analysisId((String)serviceRelationDefine.getDestId());
            return sourceIdDefinition.getName() + " to " + destIdDefinition.getName();
        }
        if (DefaultScopeDefine.inServiceInstanceRelationCatalog((int)scope)) {
            String instanceRelationId = meta.getId();
            IDManager.ServiceInstanceID.ServiceInstanceRelationDefine serviceRelationDefine = IDManager.ServiceInstanceID.analysisRelationId((String)instanceRelationId);
            IDManager.ServiceInstanceID.InstanceIDDefinition sourceIdDefinition = IDManager.ServiceInstanceID.analysisId((String)serviceRelationDefine.getSourceId());
            IDManager.ServiceID.ServiceIDDefinition sourceServiceId = IDManager.ServiceID.analysisId((String)sourceIdDefinition.getServiceId());
            IDManager.ServiceInstanceID.InstanceIDDefinition destIdDefinition = IDManager.ServiceInstanceID.analysisId((String)serviceRelationDefine.getDestId());
            IDManager.ServiceID.ServiceIDDefinition destServiceId = IDManager.ServiceID.analysisId((String)destIdDefinition.getServiceId());
            return sourceIdDefinition.getName() + " of " + sourceServiceId.getName() + " to " + destIdDefinition.getName() + " of " + destServiceId.getName();
        }
        if (DefaultScopeDefine.inEndpointRelationCatalog((int)scope)) {
            String endpointRelationId = meta.getId();
            IDManager.EndpointID.EndpointRelationDefine endpointRelationDefine = IDManager.EndpointID.analysisRelationId((String)endpointRelationId);
            IDManager.ServiceID.ServiceIDDefinition sourceService = IDManager.ServiceID.analysisId((String)endpointRelationDefine.getSourceServiceId());
            IDManager.ServiceID.ServiceIDDefinition destService = IDManager.ServiceID.analysisId((String)endpointRelationDefine.getDestServiceId());
            return endpointRelationDefine.getSource() + " in " + sourceService.getName() + " to " + endpointRelationDefine.getDest() + " in " + destService.getName();
        }
        if (DefaultScopeDefine.inProcessCatalog((int)scope)) {
            MetricsEntityMetaInfo entity = meta.getEntity();
            return entity.getProcessName() + " in " + entity.getInstanceName() + " of " + entity.getServiceName();
        }
        if (scope == 0) {
            return "";
        }
        return null;
    }
}

