/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.exporter.grpc;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Internal;
import com.google.protobuf.ProtocolMessageEnum;
import org.apache.skywalking.oap.server.exporter.grpc.MetricExporter;

public enum ValueType implements ProtocolMessageEnum
{
    LONG(0),
    DOUBLE(1),
    MULTI_LONG(2),
    UNRECOGNIZED(-1);

    public static final int LONG_VALUE = 0;
    public static final int DOUBLE_VALUE = 1;
    public static final int MULTI_LONG_VALUE = 2;
    private static final Internal.EnumLiteMap<ValueType> internalValueMap;
    private static final ValueType[] VALUES;
    private final int value;

    public final int getNumber() {
        if (this == UNRECOGNIZED) {
            throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
        }
        return this.value;
    }

    @Deprecated
    public static ValueType valueOf(int value) {
        return ValueType.forNumber(value);
    }

    public static ValueType forNumber(int value) {
        switch (value) {
            case 0: {
                return LONG;
            }
            case 1: {
                return DOUBLE;
            }
            case 2: {
                return MULTI_LONG;
            }
        }
        return null;
    }

    public static Internal.EnumLiteMap<ValueType> internalGetValueMap() {
        return internalValueMap;
    }

    public final Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
            throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
        }
        return (Descriptors.EnumValueDescriptor)ValueType.getDescriptor().getValues().get(this.ordinal());
    }

    public final Descriptors.EnumDescriptor getDescriptorForType() {
        return ValueType.getDescriptor();
    }

    public static final Descriptors.EnumDescriptor getDescriptor() {
        return (Descriptors.EnumDescriptor)MetricExporter.getDescriptor().getEnumTypes().get(0);
    }

    public static ValueType valueOf(Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != ValueType.getDescriptor()) {
            throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
            return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
    }

    private ValueType(int value) {
        this.value = value;
    }

    static {
        internalValueMap = new Internal.EnumLiteMap<ValueType>(){

            public ValueType findValueByNumber(int number) {
                return ValueType.forNumber(number);
            }
        };
        VALUES = ValueType.values();
    }
}

