/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.log.analyzer.provider.log.listener;

import com.google.protobuf.Message;
import java.util.Objects;
import lombok.Generated;
import org.apache.skywalking.apm.network.logging.v3.LogData;
import org.apache.skywalking.oap.log.analyzer.provider.LogAnalyzerModuleConfig;
import org.apache.skywalking.oap.log.analyzer.provider.log.listener.LogAnalysisListener;
import org.apache.skywalking.oap.log.analyzer.provider.log.listener.LogAnalysisListenerFactory;
import org.apache.skywalking.oap.server.core.analysis.DownSampling;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.config.NamingControl;
import org.apache.skywalking.oap.server.core.source.EndpointMeta;
import org.apache.skywalking.oap.server.core.source.ISource;
import org.apache.skywalking.oap.server.core.source.ServiceInstanceUpdate;
import org.apache.skywalking.oap.server.core.source.ServiceMeta;
import org.apache.skywalking.oap.server.core.source.SourceReceiver;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.StringUtil;

public class TrafficAnalysisListener
implements LogAnalysisListener {
    private final SourceReceiver sourceReceiver;
    private final NamingControl namingControl;
    private ServiceMeta serviceMeta;
    private ServiceInstanceUpdate instanceMeta;
    private EndpointMeta endpointMeta;

    @Override
    public void build() {
        if (Objects.nonNull(this.serviceMeta)) {
            this.sourceReceiver.receive((ISource)this.serviceMeta);
        }
        if (Objects.nonNull(this.instanceMeta)) {
            this.sourceReceiver.receive((ISource)this.instanceMeta);
        }
        if (Objects.nonNull(this.endpointMeta)) {
            this.sourceReceiver.receive((ISource)this.endpointMeta);
        }
    }

    @Override
    public LogAnalysisListener parse(LogData.Builder logData, Message extraLog) {
        Layer layer = StringUtil.isNotEmpty((String)logData.getLayer()) ? Layer.valueOf((String)logData.getLayer()) : Layer.GENERAL;
        long timeBucket = TimeBucket.getTimeBucket((long)System.currentTimeMillis(), (DownSampling)DownSampling.Minute);
        String serviceName = this.namingControl.formatServiceName(logData.getService());
        String serviceId = IDManager.ServiceID.buildId((String)serviceName, (boolean)layer.isNormal());
        this.serviceMeta = new ServiceMeta();
        this.serviceMeta.setName(this.namingControl.formatServiceName(logData.getService()));
        this.serviceMeta.setLayer(layer);
        this.serviceMeta.setTimeBucket(timeBucket);
        if (StringUtil.isNotEmpty((String)logData.getServiceInstance())) {
            this.instanceMeta = new ServiceInstanceUpdate();
            this.instanceMeta.setServiceId(serviceId);
            this.instanceMeta.setName(this.namingControl.formatInstanceName(logData.getServiceInstance()));
            this.instanceMeta.setTimeBucket(timeBucket);
        }
        if (StringUtil.isNotEmpty((String)logData.getEndpoint())) {
            this.endpointMeta = new EndpointMeta();
            this.endpointMeta.setServiceName(serviceName);
            this.endpointMeta.setServiceNormal(true);
            this.endpointMeta.setEndpoint(this.namingControl.formatEndpointName(serviceName, logData.getEndpoint()));
            this.endpointMeta.setTimeBucket(timeBucket);
        }
        return this;
    }

    @Generated
    public TrafficAnalysisListener(SourceReceiver sourceReceiver, NamingControl namingControl) {
        this.sourceReceiver = sourceReceiver;
        this.namingControl = namingControl;
    }

    public static class Factory
    implements LogAnalysisListenerFactory {
        private final SourceReceiver sourceReceiver;
        private final NamingControl namingControl;

        public Factory(ModuleManager moduleManager, LogAnalyzerModuleConfig moduleConfig) {
            this.sourceReceiver = (SourceReceiver)moduleManager.find("core").provider().getService(SourceReceiver.class);
            this.namingControl = (NamingControl)moduleManager.find("core").provider().getService(NamingControl.class);
        }

        @Override
        public LogAnalysisListener create() {
            return new TrafficAnalysisListener(this.sourceReceiver, this.namingControl);
        }
    }
}

