/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.log.analyzer.provider.log.listener;

import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.apm.network.logging.v3.LogData;
import org.apache.skywalking.oap.log.analyzer.dsl.Binding;
import org.apache.skywalking.oap.log.analyzer.dsl.DSL;
import org.apache.skywalking.oap.log.analyzer.provider.LALConfig;
import org.apache.skywalking.oap.log.analyzer.provider.LALConfigs;
import org.apache.skywalking.oap.log.analyzer.provider.LogAnalyzerModuleConfig;
import org.apache.skywalking.oap.log.analyzer.provider.log.listener.LogAnalysisListener;
import org.apache.skywalking.oap.log.analyzer.provider.log.listener.LogAnalysisListenerFactory;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogFilterListener
implements LogAnalysisListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogFilterListener.class);
    private final List<DSL> dsls;

    @Override
    public void build() {
        this.dsls.forEach(dsl -> {
            try {
                dsl.evaluate();
            }
            catch (Exception e) {
                log.warn("Failed to evaluate dsl: {}", dsl, (Object)e);
            }
        });
    }

    @Override
    public LogAnalysisListener parse(LogData.Builder logData, Message extraLog) {
        this.dsls.forEach(dsl -> dsl.bind(new Binding().log(logData.build()).extraLog(extraLog)));
        return this;
    }

    @Generated
    public LogFilterListener(List<DSL> dsls) {
        this.dsls = dsls;
    }

    public static class Factory
    implements LogAnalysisListenerFactory {
        private final List<DSL> dsls = new ArrayList<DSL>();

        public Factory(ModuleManager moduleManager, LogAnalyzerModuleConfig config) throws Exception {
            List configList = LALConfigs.load(config.getLalPath(), config.lalFiles()).stream().flatMap(it -> it.getRules().stream()).collect(Collectors.toList());
            for (LALConfig c : configList) {
                this.dsls.add(DSL.of(moduleManager, config, c.getDsl()));
            }
        }

        @Override
        public LogAnalysisListener create() {
            return new LogFilterListener(this.dsls);
        }
    }
}

