/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.log.analyzer.provider.log;

import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.apm.network.logging.v3.LogData;
import org.apache.skywalking.oap.log.analyzer.provider.LogAnalyzerModuleConfig;
import org.apache.skywalking.oap.log.analyzer.provider.log.ILogAnalysisListenerManager;
import org.apache.skywalking.oap.log.analyzer.provider.log.listener.LogAnalysisListener;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogAnalyzer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogAnalyzer.class);
    private final ModuleManager moduleManager;
    private final LogAnalyzerModuleConfig moduleConfig;
    private final ILogAnalysisListenerManager factoryManager;
    private final List<LogAnalysisListener> listeners = new ArrayList<LogAnalysisListener>();

    public void doAnalysis(LogData.Builder builder, Message extraLog) {
        if (StringUtil.isEmpty((String)builder.getService())) {
            log.debug("The log is ignored because the Service name is empty");
            return;
        }
        this.createListeners();
        if (builder.getTimestamp() == 0L) {
            builder.setTimestamp(System.currentTimeMillis());
        }
        this.notifyListener(builder, extraLog);
        this.notifyListenerToBuild();
    }

    private void notifyListener(LogData.Builder builder, Message extraLog) {
        this.listeners.forEach(listener -> listener.parse(builder, extraLog));
    }

    private void notifyListenerToBuild() {
        this.listeners.forEach(LogAnalysisListener::build);
    }

    private void createListeners() {
        this.factoryManager.getLogAnalysisListenerFactories().forEach(factory -> this.listeners.add(factory.create()));
    }

    @Generated
    public LogAnalyzer(ModuleManager moduleManager, LogAnalyzerModuleConfig moduleConfig, ILogAnalysisListenerManager factoryManager) {
        this.moduleManager = moduleManager;
        this.moduleConfig = moduleConfig;
        this.factoryManager = factoryManager;
    }
}

